/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import com.sun.jersey.core.util.Base64;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import org.codehaus.jackson.JsonNode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.test.TestData;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class UsersDocIT
extends ExclusiveServerTestBase {
    @Rule
    public TestData<RESTDocsGenerator> gen = TestData.producedThrough(RESTDocsGenerator.PRODUCER);
    private CommunityNeoServer server;

    @Before
    public void setUp() {
        ((RESTDocsGenerator)((Object)this.gen.get())).setSection("dev/rest-api");
    }

    @Test
    @Documented(value=" Invalidating the authorization token\n\n You can ask that the server generates a new authorization token. This will invalidate any existing token for the\n user.\n")
    public void regenerate_token() throws PropertyValueException, IOException {
        this.startServerWithConfiguredUser();
        String token = HTTP.POST(this.authURL(), HTTP.RawPayload.quotedJson("{'username':'neo4j','password':'secret'}")).get("authorization_token").asText();
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payload(this.quotedJson("{'password':'secret'}")).post(this.server.baseUri().resolve("/user/neo4j/authorization_token").toString());
        JsonNode data = JsonHelper.jsonNode((String)response.entity());
        String newToken = data.get("authorization_token").asText();
        Assert.assertThat((Object)newToken, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)token)));
        Assert.assertThat((Object)newToken.length(), (Matcher)CoreMatchers.not((Object)0));
        Assert.assertEquals((long)200L, (long)HTTP.withHeaders("Authorization", this.challengeResponse(newToken)).GET(this.authURL()).status());
        Assert.assertEquals((long)401L, (long)HTTP.withHeaders("Authorization", this.challengeResponse(token)).GET(this.authURL()).status());
    }

    @Test
    @Documented(value=" Changing your password for the first time\n\n When enabling authorization for the first time, you must change the password before an authorization token can be granted.\n You can choose any password you like, except the default `neo4j`.\n The response will include an authorization token.\n")
    public void change_password_first_time() throws PropertyValueException, IOException {
        this.startServer(true);
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payload(this.quotedJson("{'password':'neo4j', 'new_password':'qwerty'}")).post(this.server.baseUri().resolve("/user/neo4j/password").toString());
        JsonNode data = JsonHelper.jsonNode((String)response.entity());
        String token = data.get("authorization_token").asText();
        Assert.assertThat((Object)token.length(), (Matcher)CoreMatchers.not((Object)0));
        Assert.assertEquals((long)200L, (long)HTTP.POST(this.authURL(), HTTP.RawPayload.quotedJson("{'username':'neo4j','password':'qwerty'}")).status());
        Assert.assertEquals((long)422L, (long)HTTP.POST(this.authURL(), HTTP.RawPayload.quotedJson("{'username':'neo4j','password':'neo4j'}")).status());
    }

    @Test
    @Documented(value=" Changing your password\n\n Given that you know the current password, you can ask the server to change a users password. You can choose any\n password you like, as long as it is different from the current password.\n")
    public void change_password() throws PropertyValueException, IOException {
        this.startServerWithConfiguredUser();
        String originalToken = HTTP.POST(this.authURL(), HTTP.RawPayload.quotedJson("{'username':'neo4j','password':'secret'}")).get("authorization_token").asText();
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payload(this.quotedJson("{'password':'secret', 'new_password':'qwerty'}")).post(this.server.baseUri().resolve("/user/neo4j/password").toString());
        JsonNode data = JsonHelper.jsonNode((String)response.entity());
        String newToken = data.get("authorization_token").asText();
        Assert.assertThat((Object)newToken, (Matcher)CoreMatchers.equalTo((Object)originalToken));
        Assert.assertThat((Object)newToken.length(), (Matcher)CoreMatchers.not((Object)0));
        Assert.assertEquals((long)200L, (long)HTTP.POST(this.authURL(), HTTP.RawPayload.quotedJson("{'username':'neo4j','password':'qwerty'}")).status());
        Assert.assertEquals((long)422L, (long)HTTP.POST(this.authURL(), HTTP.RawPayload.quotedJson("{'username':'neo4j','password':'secret'}")).status());
    }

    @Test
    @Documented(value=" Setting authorization token\n\n In some cases you may want to explicitly set an authorization token for a user, for instance if you want to be\n able to use the same authorization token for multiple Neo4j instances in a cluster.\n\n This can be done by taking an authorization token generated by Neo4j and asking other Neo4j instance to use that\n token. This is similar to invalidating an existing token, except the new token to be used is passed in explicitly.\n")
    public void set_token() throws PropertyValueException, IOException {
        this.startServerWithConfiguredUser();
        String originalToken = HTTP.POST(this.authURL(), HTTP.RawPayload.quotedJson("{'username':'neo4j','password':'secret'}")).get("authorization_token").asText();
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payload(this.quotedJson("{'password':'secret', 'new_authorization_token':'EEB9E6883A24CEF7899CF35AD49D5944'}")).post(this.server.baseUri().resolve("/user/neo4j/authorization_token").toString());
        JsonNode data = JsonHelper.jsonNode((String)response.entity());
        String newToken = data.get("authorization_token").asText();
        Assert.assertThat((Object)newToken, (Matcher)CoreMatchers.equalTo((Object)"EEB9E6883A24CEF7899CF35AD49D5944"));
        Assert.assertEquals((long)200L, (long)HTTP.withHeaders("Authorization", this.challengeResponse(newToken)).GET(this.authURL()).status());
        Assert.assertEquals((long)401L, (long)HTTP.withHeaders("Authorization", this.challengeResponse(originalToken)).GET(this.authURL()).status());
    }

    @Test
    public void cantChangeToCurrentPassword() throws Exception {
        this.startServer(true);
        HTTP.Response res = HTTP.POST(this.server.baseUri().resolve("/user/neo4j/password").toString(), HTTP.RawPayload.quotedJson("{'password':'neo4j', 'new_password':'neo4j'}"));
        Assert.assertThat((Object)res.status(), (Matcher)CoreMatchers.equalTo((Object)422));
    }

    @Test
    public void shouldRateLimit() throws Exception {
        this.startServer(true);
        this.assertRateLimited("POST", this.server.baseUri().resolve("/user/neo4j/password"), "{'password':'something that is wrong', 'new_password':'secret'}");
        this.assertRateLimited("POST", this.server.baseUri().resolve("/user/neo4j/authorization_token"), "{'password':'something that is wrong'}");
        this.assertRateLimited("POST", this.server.baseUri().resolve("/user/neo4j/authorization_token"), "{'password':'something that is wrong','new_authorization_token':'asd'}");
    }

    @Test
    public void shouldRequireAuthorization() throws Exception {
        this.startServer(true);
        this.assertAuthorizationNeeded("POST", this.server.baseUri().resolve("/user/neo4j/password"), "{'password':'something that is wrong', 'new_password':'secret'}");
        this.assertAuthorizationNeeded("POST", this.server.baseUri().resolve("/user/neo4j/authorization_token"), "{'password':'something that is wrong'}");
        this.assertAuthorizationNeeded("POST", this.server.baseUri().resolve("/user/neo4j/authorization_token"), "{'password':'something that is wrong','new_authorization_token':'asd'}");
    }

    private void assertAuthorizationNeeded(String method, URI ur, String payload) throws JsonParseException {
        HTTP.Response response = HTTP.request(method, ur.toString(), HTTP.RawPayload.quotedJson(payload));
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)422));
        Assert.assertThat((Object)response.get("errors").get(0).get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)"Neo.ClientError.Security.AuthenticationFailed"));
        Assert.assertThat((Object)response.get("errors").get(0).get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"Invalid username and/or password."));
    }

    private void assertRateLimited(String method, URI uri, String payload) throws JsonParseException {
        long timeout = System.currentTimeMillis() + 30000L;
        HTTP.Response response = null;
        while (System.currentTimeMillis() < timeout && (response = HTTP.request(method, uri.toString(), HTTP.RawPayload.quotedJson(payload))).status() != 429) {
        }
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)429));
        Assert.assertThat((Object)response.get("errors").get(0).get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)"Neo.ClientError.Security.AuthenticationRateLimit"));
        Assert.assertThat((Object)response.get("errors").get(0).get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"Too many failed authentication requests. Please try again in 5 seconds."));
    }

    @After
    public void cleanup() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void startServer(boolean authEnabled) throws IOException {
        new File("neo4j-home/data/dbms/authorization").delete();
        this.server = CommunityServerBuilder.server().withProperty(ServerSettings.authorization_enabled.name(), Boolean.toString(authEnabled)).build();
        this.server.start();
    }

    public void startServerWithConfiguredUser() throws IOException {
        this.startServer(true);
        HTTP.Response put = HTTP.POST(this.server.baseUri().resolve("/user/neo4j/password").toString(), HTTP.RawPayload.quotedJson("{'password':'neo4j', 'new_password':'secret'}"));
        Assert.assertEquals((long)200L, (long)put.status());
    }

    private String challengeResponse(String token) {
        return "Basic realm=\"Neo4j\" " + this.base64(":" + token);
    }

    private String authURL() {
        return this.server.baseUri().resolve("authentication").toString();
    }

    private String base64(String value) {
        return new String(Base64.encode((String)value), Charset.forName("UTF-8"));
    }

    private String quotedJson(String singleQuoted) {
        return singleQuoted.replaceAll("'", "\"");
    }
}

