/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.codehaus.jackson.JsonNode;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.impl.util.TestLogger;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.transactional.ExecutionResultSerializer;
import org.neo4j.server.rest.transactional.ResultDataContent;
import org.neo4j.server.rest.transactional.error.Neo4jError;
import org.neo4j.test.Property;
import org.neo4j.test.mocking.GraphMock;
import org.neo4j.test.mocking.Link;
import org.neo4j.test.mocking.Properties;

public class ExecutionResultSerializerTest {
    private static final Map<String, Object> NO_ARGS = Collections.emptyMap();
    private static final Set<String> NO_IDS = Collections.emptySet();
    private static final List<ExecutionPlanDescription> NO_PLANS = Collections.emptyList();

    @Test
    public void shouldSerializeResponseWithCommitUriOnly() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, null, StringLogger.DEV_NULL);
        serializer.transactionCommitUri(URI.create("commit/uri/1"));
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"commit\":\"commit/uri/1\",\"results\":[],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithCommitUriAndResults() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, null, StringLogger.DEV_NULL);
        Result executionResult = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"column1", "value1", "column2", "value2"}));
        serializer.transactionCommitUri(URI.create("commit/uri/1"));
        serializer.statementResult(executionResult, false, new ResultDataContent[0]);
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"commit\":\"commit/uri/1\",\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithResultsOnly() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, null, StringLogger.DEV_NULL);
        Result executionResult = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"column1", "value1", "column2", "value2"}));
        serializer.statementResult(executionResult, false, new ResultDataContent[0]);
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithCommitUriAndResultsAndErrors() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, null, StringLogger.DEV_NULL);
        Result executionResult = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"column1", "value1", "column2", "value2"}));
        serializer.transactionCommitUri(URI.create("commit/uri/1"));
        serializer.statementResult(executionResult, false, new ResultDataContent[0]);
        serializer.errors(Arrays.asList(new Neo4jError((Status)Status.Request.InvalidFormat, (Throwable)new Exception("cause1"))));
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"commit\":\"commit/uri/1\",\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"]}]}],\"errors\":[{\"code\":\"Neo.ClientError.Request.InvalidFormat\",\"message\":\"cause1\"}]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithResultsAndErrors() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, null, StringLogger.DEV_NULL);
        Result executionResult = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"column1", "value1", "column2", "value2"}));
        serializer.statementResult(executionResult, false, new ResultDataContent[0]);
        serializer.errors(Arrays.asList(new Neo4jError((Status)Status.Request.InvalidFormat, (Throwable)new Exception("cause1"))));
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"]}]}],\"errors\":[{\"code\":\"Neo.ClientError.Request.InvalidFormat\",\"message\":\"cause1\"}]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithCommitUriAndErrors() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, null, StringLogger.DEV_NULL);
        serializer.transactionCommitUri(URI.create("commit/uri/1"));
        serializer.errors(Arrays.asList(new Neo4jError((Status)Status.Request.InvalidFormat, (Throwable)new Exception("cause1"))));
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"commit\":\"commit/uri/1\",\"results\":[],\"errors\":[{\"code\":\"Neo.ClientError.Request.InvalidFormat\",\"message\":\"cause1\"}]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithErrorsOnly() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, null, StringLogger.DEV_NULL);
        serializer.errors(Arrays.asList(new Neo4jError((Status)Status.Request.InvalidFormat, (Throwable)new Exception("cause1"))));
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[],\"errors\":[{\"code\":\"Neo.ClientError.Request.InvalidFormat\",\"message\":\"cause1\"}]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithNoCommitUriResultsOrErrors() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, null, StringLogger.DEV_NULL);
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithMultipleResultRows() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, null, StringLogger.DEV_NULL);
        Result executionResult = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"column1", "value1", "column2", "value2"}), MapUtil.map((Object[])new Object[]{"column1", "value3", "column2", "value4"}));
        serializer.statementResult(executionResult, false, new ResultDataContent[0]);
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"]},{\"row\":[\"value3\",\"value4\"]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithMultipleResults() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, null, StringLogger.DEV_NULL);
        Result executionResult1 = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"column1", "value1", "column2", "value2"}));
        Result executionResult2 = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"column3", "value3", "column4", "value4"}));
        serializer.statementResult(executionResult1, false, new ResultDataContent[0]);
        serializer.statementResult(executionResult2, false, new ResultDataContent[0]);
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"]}]},{\"columns\":[\"column3\",\"column4\"],\"data\":[{\"row\":[\"value3\",\"value4\"]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldSerializeNodeAsMapOfProperties() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, null, StringLogger.DEV_NULL);
        Result executionResult = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"node", GraphMock.node((long)1L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"a", (Object)12), Property.property((String)"b", (Object)true), Property.property((String)"c", (Object)new int[]{1, 0, 1, 2}), Property.property((String)"d", (Object)new byte[]{1, 0, 1, 2}), Property.property((String)"e", (Object)new String[]{"a", "b", "\u00e4\u00e4\u00f6"})}), (String[])new String[0])}));
        serializer.statementResult(executionResult, false, new ResultDataContent[0]);
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"node\"],\"data\":[{\"row\":[{\"a\":12,\"b\":true,\"c\":[1,0,1,2],\"d\":[1,0,1,2],\"e\":[\"a\",\"b\",\"\u00e4\u00e4\u00f6\"]}]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldSerializeNestedEntities() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, null, StringLogger.DEV_NULL);
        Node a = GraphMock.node((long)1L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"foo", (Object)12)}), (String[])new String[0]);
        Node b = GraphMock.node((long)2L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"bar", (Object)false)}), (String[])new String[0]);
        Relationship r = GraphMock.relationship((long)1L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"baz", (Object)"quux")}), (Node)a, (String)"FRAZZLE", (Node)b);
        Result executionResult = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"nested", new TreeMap(MapUtil.map((Object[])new Object[]{"node", a, "edge", r, "path", GraphMock.path((Node)a, (Link[])new Link[]{GraphMock.link((Relationship)r, (Node)b)})}))}));
        serializer.statementResult(executionResult, false, new ResultDataContent[0]);
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"nested\"],\"data\":[{\"row\":[{\"edge\":{\"baz\":\"quux\"},\"node\":{\"foo\":12},\"path\":[{\"foo\":12},{\"baz\":\"quux\"},{\"bar\":false}]}]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldSerializePathAsListOfMapsOfProperties() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, null, StringLogger.DEV_NULL);
        Result executionResult = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"path", ExecutionResultSerializerTest.mockPath(MapUtil.map((Object[])new Object[]{"key1", "value1"}), MapUtil.map((Object[])new Object[]{"key2", "value2"}), MapUtil.map((Object[])new Object[]{"key3", "value3"}))}));
        serializer.statementResult(executionResult, false, new ResultDataContent[0]);
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"path\"],\"data\":[{\"row\":[[{\"key1\":\"value1\"},{\"key2\":\"value2\"},{\"key3\":\"value3\"}]]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldProduceWellFormedJsonEvenIfResultIteratorThrowsExceptionOnNext() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, null, StringLogger.DEV_NULL);
        Map data = MapUtil.map((Object[])new Object[]{"column1", "value1", "column2", "value2"});
        Result executionResult = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)executionResult.columns()).thenReturn(new ArrayList(data.keySet()));
        Mockito.when((Object)executionResult.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)executionResult.next()).thenReturn((Object)data).thenThrow(new Throwable[]{new RuntimeException("Stuff went wrong!")});
        try {
            serializer.statementResult(executionResult, false, new ResultDataContent[0]);
            Assert.fail((String)"should have thrown exception");
        }
        catch (RuntimeException e) {
            serializer.errors(Arrays.asList(new Neo4jError((Status)Status.Statement.ExecutionFailure, (Throwable)e)));
        }
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"]}]}],\"errors\":[{\"code\":\"Neo.DatabaseError.Statement.ExecutionFailure\",\"message\":\"Stuff went wrong!\",\"stackTrace\":***}]}", (Object)this.replaceStackTrace(result, "***"));
    }

    @Test
    public void shouldProduceWellFormedJsonEvenIfResultIteratorThrowsExceptionOnHasNext() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, null, StringLogger.DEV_NULL);
        Map data = MapUtil.map((Object[])new Object[]{"column1", "value1", "column2", "value2"});
        Result executionResult = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)executionResult.columns()).thenReturn(new ArrayList(data.keySet()));
        Mockito.when((Object)executionResult.hasNext()).thenReturn((Object)true).thenThrow(new Throwable[]{new RuntimeException("Stuff went wrong!")});
        Mockito.when((Object)executionResult.next()).thenReturn((Object)data);
        try {
            serializer.statementResult(executionResult, false, new ResultDataContent[0]);
            Assert.fail((String)"should have thrown exception");
        }
        catch (RuntimeException e) {
            serializer.errors(Arrays.asList(new Neo4jError((Status)Status.Statement.ExecutionFailure, (Throwable)e)));
        }
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"]}]}],\"errors\":[{\"code\":\"Neo.DatabaseError.Statement.ExecutionFailure\",\"message\":\"Stuff went wrong!\",\"stackTrace\":***}]}", (Object)this.replaceStackTrace(result, "***"));
    }

    @Test
    public void shouldProduceResultStreamWithGraphEntries() throws Exception {
        Node[] node = new Node[]{GraphMock.node((long)0L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"node0")}), (String[])new String[]{"Node"}), GraphMock.node((long)1L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"node1")}), (String[])new String[0]), GraphMock.node((long)2L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"node2")}), (String[])new String[]{"This", "That"}), GraphMock.node((long)3L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"node3")}), (String[])new String[]{"Other"})};
        Relationship[] rel = new Relationship[]{GraphMock.relationship((long)0L, (Node)node[0], (String)"KNOWS", (Node)node[1], (Property[])new Property[]{Property.property((String)"name", (Object)"rel0")}), GraphMock.relationship((long)1L, (Node)node[2], (String)"LOVES", (Node)node[3], (Property[])new Property[]{Property.property((String)"name", (Object)"rel1")})};
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, null, StringLogger.DEV_NULL);
        serializer.statementResult(ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"node", node[0], "rel", rel[0]}), MapUtil.map((Object[])new Object[]{"node", node[2], "rel", rel[1]})), false, new ResultDataContent[]{ResultDataContent.row, ResultDataContent.graph});
        serializer.finish();
        String result = output.toString("UTF-8");
        String node0 = "{\"id\":\"0\",\"labels\":[\"Node\"],\"properties\":{\"name\":\"node0\"}}";
        String node1 = "{\"id\":\"1\",\"labels\":[],\"properties\":{\"name\":\"node1\"}}";
        String node2 = "{\"id\":\"2\",\"labels\":[\"This\",\"That\"],\"properties\":{\"name\":\"node2\"}}";
        String node3 = "{\"id\":\"3\",\"labels\":[\"Other\"],\"properties\":{\"name\":\"node3\"}}";
        String rel0 = "\"relationships\":[{\"id\":\"0\",\"type\":\"KNOWS\",\"startNode\":\"0\",\"endNode\":\"1\",\"properties\":{\"name\":\"rel0\"}}]}";
        String rel1 = "\"relationships\":[{\"id\":\"1\",\"type\":\"LOVES\",\"startNode\":\"2\",\"endNode\":\"3\",\"properties\":{\"name\":\"rel1\"}}]}";
        String row0 = "{\"row\":[{\"name\":\"node0\"},{\"name\":\"rel0\"}],\"graph\":{\"nodes\":[";
        String row1 = "{\"row\":[{\"name\":\"node2\"},{\"name\":\"rel1\"}],\"graph\":{\"nodes\":[";
        int n0 = result.indexOf(node0);
        int n1 = result.indexOf(node1);
        int n2 = result.indexOf(node2);
        int n3 = result.indexOf(node3);
        int r0 = result.indexOf(rel0);
        int r1 = result.indexOf(rel1);
        int _0 = result.indexOf(row0);
        int _1 = result.indexOf(row1);
        Assert.assertTrue((String)"result should contain row0", (_0 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"result should contain row1 after row0", (_1 > _0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"result should contain node0 after row0", (n0 > _0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"result should contain node1 after row0", (n1 > _0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"result should contain node2 after row1", (n2 > _1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"result should contain node3 after row1", (n3 > _1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"result should contain rel0 after node0 and node1", (r0 > n0 && r0 > n1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"result should contain rel1 after node2 and node3", (r1 > n2 && r1 > n3 ? 1 : 0) != 0);
    }

    @Test
    public void shouldProduceResultStreamWithLegacyRestFormat() throws Exception {
        Node[] node = new Node[]{GraphMock.node((long)0L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"node0")}), (String[])new String[0]), GraphMock.node((long)1L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"node1")}), (String[])new String[0]), GraphMock.node((long)2L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"node2")}), (String[])new String[0])};
        Relationship[] rel = new Relationship[]{GraphMock.relationship((long)0L, (Node)node[0], (String)"KNOWS", (Node)node[1], (Property[])new Property[]{Property.property((String)"name", (Object)"rel0")}), GraphMock.relationship((long)1L, (Node)node[2], (String)"LOVES", (Node)node[1], (Property[])new Property[]{Property.property((String)"name", (Object)"rel1")})};
        Path path = GraphMock.path((Node)node[0], (Link[])new Link[]{GraphMock.link((Relationship)rel[0], (Node)node[1]), GraphMock.link((Relationship)rel[1], (Node)node[2])});
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, URI.create("http://base.uri/"), StringLogger.DEV_NULL);
        serializer.statementResult(ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"node", node[0], "rel", rel[0], "path", path, "map", MapUtil.map((Object[])new Object[]{"n1", node[1], "r1", rel[1]})})), false, new ResultDataContent[]{ResultDataContent.rest});
        serializer.finish();
        String result = output.toString("UTF-8");
        JsonNode json = JsonHelper.jsonNode((String)result);
        HashMap<String, Integer> columns = new HashMap<String, Integer>();
        int col = 0;
        JsonNode results = json.get("results").get(0);
        for (JsonNode column : results.get("columns")) {
            columns.put(column.getTextValue(), col++);
        }
        JsonNode row = results.get("data").get(0).get("rest");
        JsonNode jsonNode = row.get(((Integer)columns.get("node")).intValue());
        JsonNode jsonRel = row.get(((Integer)columns.get("rel")).intValue());
        JsonNode jsonPath = row.get(((Integer)columns.get("path")).intValue());
        JsonNode jsonMap = row.get(((Integer)columns.get("map")).intValue());
        Assert.assertEquals((Object)"http://base.uri/node/0", (Object)jsonNode.get("self").getTextValue());
        Assert.assertEquals((Object)"http://base.uri/relationship/0", (Object)jsonRel.get("self").getTextValue());
        Assert.assertEquals((Object)2, (Object)jsonPath.get("length").getNumberValue());
        Assert.assertEquals((Object)"http://base.uri/node/0", (Object)jsonPath.get("start").getTextValue());
        Assert.assertEquals((Object)"http://base.uri/node/2", (Object)jsonPath.get("end").getTextValue());
        Assert.assertEquals((Object)"http://base.uri/node/1", (Object)jsonMap.get("n1").get("self").getTextValue());
        Assert.assertEquals((Object)"http://base.uri/relationship/1", (Object)jsonMap.get("r1").get("self").getTextValue());
    }

    @Test
    public void shouldProduceResultStreamWithLegacyRestFormatAndNestedMaps() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, URI.create("http://base.uri/"), StringLogger.DEV_NULL);
        serializer.statementResult(ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"map", MapUtil.map((Object[])new Object[]{"one", MapUtil.map((Object[])new Object[]{"two", Arrays.asList("wait for it...", MapUtil.map((Object[])new Object[]{"three", "GO!"}))})})})), false, new ResultDataContent[]{ResultDataContent.rest});
        serializer.finish();
        String result = output.toString("UTF-8");
        JsonNode json = JsonHelper.jsonNode((String)result);
        HashMap<String, Integer> columns = new HashMap<String, Integer>();
        int col = 0;
        JsonNode results = json.get("results").get(0);
        for (JsonNode column : results.get("columns")) {
            columns.put(column.getTextValue(), col++);
        }
        JsonNode row = results.get("data").get(0).get("rest");
        JsonNode jsonMap = row.get(((Integer)columns.get("map")).intValue());
        Assert.assertEquals((Object)"wait for it...", (Object)jsonMap.get("one").get("two").get(0).asText());
        Assert.assertEquals((Object)"GO!", (Object)jsonMap.get("one").get("two").get(1).get("three").asText());
    }

    @Test
    public void shouldSerializePlanWithoutChildButAllKindsOfSupportedArguments() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, URI.create("http://base.uri/"), StringLogger.DEV_NULL);
        String operatorType = "Ich habe einen Plan";
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("string", "A String");
        args.put("bool", true);
        args.put("number", 1);
        args.put("double", 2.3);
        args.put("listOfInts", Arrays.asList(1, 2, 3));
        args.put("listOfListOfInts", Arrays.asList(Arrays.asList(1, 2, 3)));
        ExecutionPlanDescription planDescription = this.mockedPlanDescription(operatorType, NO_IDS, args, NO_PLANS);
        serializer.statementResult(ExecutionResultSerializerTest.mockExecutionResult(planDescription, new Map[0]), false, new ResultDataContent[]{ResultDataContent.rest});
        serializer.finish();
        String resultString = output.toString("UTF-8");
        this.assertIsPlanRoot(resultString);
        Map<String, ?> rootMap = this.planRootMap(resultString);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"operatorType", "identifiers", "children", "string", "bool", "number", "double", "listOfInts", "listOfListOfInts"}), rootMap.keySet());
        Assert.assertEquals((Object)operatorType, rootMap.get("operatorType"));
        Assert.assertEquals(args.get("string"), rootMap.get("string"));
        Assert.assertEquals(args.get("bool"), rootMap.get("bool"));
        Assert.assertEquals(args.get("number"), rootMap.get("number"));
        Assert.assertEquals(args.get("double"), rootMap.get("double"));
        Assert.assertEquals(args.get("listOfInts"), rootMap.get("listOfInts"));
        Assert.assertEquals(args.get("listOfListOfInts"), rootMap.get("listOfListOfInts"));
    }

    @Test
    public void shouldSerializePlanWithoutChildButWithIdentifiers() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, URI.create("http://base.uri/"), StringLogger.DEV_NULL);
        String operatorType = "Ich habe einen Plan";
        String id1 = "id1";
        String id2 = "id2";
        String id3 = "id3";
        ExecutionPlanDescription planDescription = this.mockedPlanDescription(operatorType, IteratorUtil.asSet((Object[])new String[]{id1, id2, id3}), NO_ARGS, NO_PLANS);
        serializer.statementResult(ExecutionResultSerializerTest.mockExecutionResult(planDescription, new Map[0]), false, new ResultDataContent[]{ResultDataContent.rest});
        serializer.finish();
        String resultString = output.toString("UTF-8");
        this.assertIsPlanRoot(resultString);
        Map<String, ?> rootMap = this.planRootMap(resultString);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"operatorType", "identifiers", "children"}), rootMap.keySet());
        Assert.assertEquals((Object)operatorType, rootMap.get("operatorType"));
        Assert.assertEquals(Arrays.asList(id2, id1, id3), rootMap.get("identifiers"));
    }

    @Test
    public void shouldSerializePlanWithChildren() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, URI.create("http://base.uri/"), StringLogger.DEV_NULL);
        String leftId = "leftId";
        String rightId = "rightId";
        String parentId = "parentId";
        ExecutionPlanDescription left = this.mockedPlanDescription("child", IteratorUtil.asSet((Object[])new String[]{leftId}), MapUtil.map((Object[])new Object[]{"id", 1}), NO_PLANS);
        ExecutionPlanDescription right = this.mockedPlanDescription("child", IteratorUtil.asSet((Object[])new String[]{rightId}), MapUtil.map((Object[])new Object[]{"id", 2}), NO_PLANS);
        ExecutionPlanDescription parent = this.mockedPlanDescription("parent", IteratorUtil.asSet((Object[])new String[]{parentId}), MapUtil.map((Object[])new Object[]{"id", 0}), Arrays.asList(left, right));
        serializer.statementResult(ExecutionResultSerializerTest.mockExecutionResult(parent, new Map[0]), false, new ResultDataContent[]{ResultDataContent.rest});
        serializer.finish();
        String result = output.toString("UTF-8");
        JsonNode root = this.assertIsPlanRoot(result);
        Assert.assertEquals((Object)"parent", (Object)root.get("operatorType").getTextValue());
        Assert.assertEquals((long)0L, (long)root.get("id").asLong());
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{parentId}), this.identifiersOf(root));
        HashSet<Integer> childIds = new HashSet<Integer>();
        HashSet<Set<String>> identifiers = new HashSet<Set<String>>();
        for (JsonNode child : root.get("children")) {
            Assert.assertTrue((String)"Expected object", (boolean)child.isObject());
            Assert.assertEquals((Object)"child", (Object)child.get("operatorType").getTextValue());
            identifiers.add(this.identifiersOf(child));
            childIds.add(child.get("id").asInt());
        }
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{1, 2}), childIds);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Set[]{IteratorUtil.asSet((Object[])new String[]{leftId}), IteratorUtil.asSet((Object[])new String[]{rightId})}), identifiers);
    }

    private Set<String> identifiersOf(JsonNode root) {
        HashSet<String> parentIds = new HashSet<String>();
        for (JsonNode id : root.get("identifiers")) {
            parentIds.add(id.asText());
        }
        return parentIds;
    }

    private ExecutionPlanDescription mockedPlanDescription(String operatorType, Set<String> identifiers, Map<String, Object> args, List<ExecutionPlanDescription> children) {
        ExecutionPlanDescription planDescription = (ExecutionPlanDescription)Mockito.mock(ExecutionPlanDescription.class);
        Mockito.when((Object)planDescription.getChildren()).thenReturn(children);
        Mockito.when((Object)planDescription.getName()).thenReturn((Object)operatorType);
        Mockito.when((Object)planDescription.getArguments()).thenReturn(args);
        Mockito.when((Object)planDescription.getIdentifiers()).thenReturn(identifiers);
        return planDescription;
    }

    private JsonNode assertIsPlanRoot(String result) throws UnsupportedEncodingException, JsonParseException {
        JsonNode json = JsonHelper.jsonNode((String)result);
        JsonNode results = json.get("results").get(0);
        JsonNode plan = results.get("plan");
        Assert.assertTrue((String)"Expected plan to be an object", (plan != null && plan.isObject() ? 1 : 0) != 0);
        JsonNode root = plan.get("root");
        Assert.assertTrue((String)"Expected plan to be an object", (root != null && root.isObject() ? 1 : 0) != 0);
        return root;
    }

    private Map<String, ?> planRootMap(String resultString) throws JsonParseException {
        Map resultMap = (Map)((List)((Map)JsonHelper.readJson((String)resultString)).get("results")).get(0);
        Map planMap = (Map)resultMap.get("plan");
        return (Map)planMap.get("root");
    }

    @Test
    public void shouldLogIOErrors() throws Exception {
        IOException failure = new IOException();
        OutputStream output = (OutputStream)Mockito.mock(OutputStream.class, (Answer)new ThrowsException((Throwable)failure));
        TestLogger log = new TestLogger();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer(output, null, (StringLogger)log);
        serializer.finish();
        log.assertExactly(new TestLogger.LogCall[]{TestLogger.LogCall.error((String)"Failed to generate JSON output.", (Throwable)failure)});
    }

    @Test
    public void shouldAbbreviateWellKnownIOErrors() throws Exception {
        OutputStream output = (OutputStream)Mockito.mock(OutputStream.class, (Answer)new ThrowsException((Throwable)new IOException("Broken pipe")));
        TestLogger log = new TestLogger();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer(output, null, (StringLogger)log);
        serializer.finish();
        log.assertExactly(new TestLogger.LogCall[]{TestLogger.LogCall.error((String)"Unable to reply to request, because the client has closed the connection (Broken pipe).")});
    }

    @Test
    public void shouldCloseResultIterator() throws Exception {
        OutputStream output = (OutputStream)Mockito.mock(OutputStream.class);
        ExecutionResultSerializer serializer = new ExecutionResultSerializer(output, null, null);
        IllegalStateException onCloseException = new IllegalStateException("Iterator closed");
        Result result = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)result.hasNext()).thenReturn((Object)true);
        Mockito.when((Object)result.next()).thenThrow(new Throwable[]{onCloseException});
        try {
            serializer.statementResult(result, false, new ResultDataContent[0]);
            Assert.fail((String)"Expected IllegalStateException to be thrown when closing the iterator");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)onCloseException, (Object)e);
        }
        ((Result)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).columns();
        ((Result)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).hasNext();
        ((Result)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).next();
        ((Result)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{result});
    }

    @SafeVarargs
    private static Result mockExecutionResult(Map<String, Object> ... rows) {
        return ExecutionResultSerializerTest.mockExecutionResult(null, rows);
    }

    @SafeVarargs
    private static Result mockExecutionResult(ExecutionPlanDescription planDescription, Map<String, Object> ... rows) {
        TreeSet<String> keys = new TreeSet<String>();
        for (Map<String, Object> row : rows) {
            keys.addAll(row.keySet());
        }
        Result executionResult = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)executionResult.columns()).thenReturn(new ArrayList(keys));
        final Iterator<Map<String, Object>> inner = Arrays.asList(rows).iterator();
        Mockito.when((Object)executionResult.hasNext()).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return inner.hasNext();
            }
        });
        Mockito.when((Object)executionResult.next()).thenAnswer((Answer)new Answer<Map<String, Object>>(){

            public Map<String, Object> answer(InvocationOnMock invocation) throws Throwable {
                return (Map)inner.next();
            }
        });
        Mockito.when((Object)executionResult.getQueryExecutionType()).thenReturn((Object)(null != planDescription ? QueryExecutionType.profiled((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE) : QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE)));
        if (executionResult.getQueryExecutionType().requestedExecutionPlanDescription()) {
            Mockito.when((Object)executionResult.getExecutionPlanDescription()).thenReturn((Object)planDescription);
        }
        return executionResult;
    }

    private static Path mockPath(Map<String, Object> startNodeProperties, Map<String, Object> relationshipProperties, Map<String, Object> endNodeProperties) {
        Node startNode = GraphMock.node((long)1L, (Properties)Properties.properties(startNodeProperties), (String[])new String[0]);
        Node endNode = GraphMock.node((long)2L, (Properties)Properties.properties(endNodeProperties), (String[])new String[0]);
        Relationship relationship = GraphMock.relationship((long)1L, (Properties)Properties.properties(relationshipProperties), (Node)startNode, (String)"RELATED", (Node)endNode);
        return GraphMock.path((Node)startNode, (Link[])new Link[]{Link.link((Relationship)relationship, (Node)endNode)});
    }

    private String replaceStackTrace(String json, String matchableStackTrace) {
        return json.replaceAll("\"stackTrace\":\"[^\"]*\"", "\"stackTrace\":" + matchableStackTrace);
    }
}

