/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.net.URI;
import java.net.URISyntaxException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.transactional.TransactionFacade;

public class TransactionFacadeTest {
    @Test
    public void baseUrlMustAddMissingDbDataPrefix() throws URISyntaxException {
        URI requestUri = new URI("http://localhost:7474/");
        URI baseUri = TransactionFacade.baseUri((URI)requestUri);
        URI expectedUri = new URI("http://localhost:7474/db/data");
        Assert.assertThat((Object)baseUri, (Matcher)Matchers.is((Object)expectedUri));
    }

    @Test
    public void baseUrlMustReduceOverqualifiedRequestUri() throws URISyntaxException {
        URI requestUri = new URI("http://localhost:7474/db/data/transaction/commit");
        URI baseUri = TransactionFacade.baseUri((URI)requestUri);
        URI expectedUri = new URI("http://localhost:7474/db/data");
        Assert.assertThat((Object)baseUri, (Matcher)Matchers.is((Object)expectedUri));
    }

    @Test
    public void baseUrlMustRetainHttpsSchema() throws URISyntaxException {
        URI requestUri = new URI("https://localhost:7474/");
        URI baseUri = TransactionFacade.baseUri((URI)requestUri);
        URI expectedUri = new URI("https://localhost:7474/db/data");
        Assert.assertThat((Object)baseUri, (Matcher)Matchers.is((Object)expectedUri));
    }

    @Test
    public void baseUrlMustRetainHost() throws URISyntaxException {
        URI requestUri = new URI("http://dbserver.com:7474/");
        URI baseUri = TransactionFacade.baseUri((URI)requestUri);
        URI expectedUri = new URI("http://dbserver.com:7474/db/data");
        Assert.assertThat((Object)baseUri, (Matcher)Matchers.is((Object)expectedUri));
    }

    @Test
    public void baseUrlMustRetainPort() throws URISyntaxException {
        URI requestUri = new URI("http://localhost:7484/");
        URI baseUri = TransactionFacade.baseUri((URI)requestUri);
        URI expectedUri = new URI("http://localhost:7484/db/data");
        Assert.assertThat((Object)baseUri, (Matcher)Matchers.is((Object)expectedUri));
    }

    @Test
    public void baseUrlMustRetainUserInfo() throws URISyntaxException {
        URI requestUri = new URI("http://username:password@localhost:7484/");
        URI baseUri = TransactionFacade.baseUri((URI)requestUri);
        URI expectedUri = new URI("http://username:password@localhost:7484/db/data");
        Assert.assertThat((Object)baseUri, (Matcher)Matchers.is((Object)expectedUri));
    }
}

