/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.error;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.transactional.error.ErrorDocumentationGenerator;

public class ErrorDocumentationGeneratorTest {
    @Test
    public void tablesShouldFormatAsAsciiDoc() throws Exception {
        ErrorDocumentationGenerator.Table table = new ErrorDocumentationGenerator.Table();
        table.setCols("COLS");
        table.setHeader(new String[]{"A", "B"});
        table.addRow(new Object[]{1, 2});
        table.addRow(new Object[]{3, 4});
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)buf, false, "UTF-8");
        table.print(out);
        out.flush();
        String result = buf.toString("UTF-8");
        String n = System.lineSeparator();
        String expected = "[options=\"header\", cols=\"COLS\"]" + n + "|===" + n + "|A |B " + n + "|1 |2 " + n + "|3 |4 " + n + "|===" + n;
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected)));
    }

    @Test
    public void shouldGenerateTableOfClassifications() throws Exception {
        ErrorDocumentationGenerator gen = new ErrorDocumentationGenerator();
        ErrorDocumentationGenerator.Table table = gen.generateClassificationDocs();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        table.print(new PrintStream((OutputStream)buf, true, "UTF-8"));
        String actual = buf.toString("UTF-8");
        Assert.assertThat((Object)actual, (Matcher)Matchers.stringContainsInOrder(Arrays.asList("DatabaseError", "Rollback")));
    }

    @Test
    public void shouldGenerateTableOfStatusCodes() throws Exception {
        ErrorDocumentationGenerator gen = new ErrorDocumentationGenerator();
        ErrorDocumentationGenerator.Table table = gen.generateStatusCodeDocs();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        table.print(new PrintStream((OutputStream)buf, true, "UTF-8"));
        String actual = buf.toString("UTF-8");
        Assert.assertThat((Object)actual, (Matcher)Matchers.stringContainsInOrder(Arrays.asList("UnknownFailure", "An unknown failure occurred")));
    }
}

