/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.util.Collection;
import java.util.Map;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.rest.domain.EndNodeNotFoundException;
import org.neo4j.server.rest.domain.StartNodeNotFoundException;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.ConstraintDefinitionRepresentation;
import org.neo4j.server.rest.repr.IndexDefinitionRepresentation;
import org.neo4j.server.rest.repr.IndexRepresentation;
import org.neo4j.server.rest.repr.IndexedEntityRepresentation;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.web.DatabaseActions;
import org.neo4j.server.rest.web.NoSuchPropertyException;
import org.neo4j.server.rest.web.NodeNotFoundException;
import org.neo4j.server.rest.web.OperationFailureException;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.server.rest.web.RelationshipNotFoundException;

public class TransactionWrappedDatabaseActions
extends DatabaseActions {
    private final GraphDatabaseAPI graph;

    public TransactionWrappedDatabaseActions(LeaseManager leaseManager, GraphDatabaseAPI graph) {
        super(leaseManager, graph);
        this.graph = graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRepresentation createNode(Map<String, Object> properties, Label ... labels) throws PropertyValueException {
        Transaction transaction = this.graph.beginTx();
        try {
            NodeRepresentation nodeRepresentation = super.createNode(properties, labels);
            transaction.success();
            NodeRepresentation nodeRepresentation2 = nodeRepresentation;
            return nodeRepresentation2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRepresentation getNode(long nodeId) throws NodeNotFoundException {
        Transaction transaction = this.graph.beginTx();
        try {
            NodeRepresentation node = super.getNode(nodeId);
            transaction.success();
            NodeRepresentation nodeRepresentation = node;
            return nodeRepresentation;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(long nodeId) throws NodeNotFoundException, OperationFailureException {
        Transaction transaction = this.graph.beginTx();
        try {
            super.deleteNode(nodeId);
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeProperty(long nodeId, String key, Object value) throws PropertyValueException, NodeNotFoundException {
        Transaction transaction = this.graph.beginTx();
        try {
            super.setNodeProperty(nodeId, key, value);
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeProperty(long nodeId, String key) throws NodeNotFoundException, NoSuchPropertyException {
        Transaction transaction = this.graph.beginTx();
        try {
            super.removeNodeProperty(nodeId, key);
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllNodeProperties(long nodeId, Map<String, Object> properties) throws PropertyValueException, NodeNotFoundException {
        Transaction transaction = this.graph.beginTx();
        try {
            super.setAllNodeProperties(nodeId, properties);
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllNodeProperties(long nodeId) throws NodeNotFoundException, PropertyValueException {
        Transaction transaction = this.graph.beginTx();
        try {
            super.removeAllNodeProperties(nodeId);
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLabelToNode(long nodeId, Collection<String> labelNames) throws NodeNotFoundException, BadInputException {
        Transaction transaction = this.graph.beginTx();
        try {
            super.addLabelToNode(nodeId, labelNames);
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLabelFromNode(long nodeId, String labelName) throws NodeNotFoundException {
        Transaction transaction = this.graph.beginTx();
        try {
            super.removeLabelFromNode(nodeId, labelName);
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexRepresentation createNodeIndex(Map<String, Object> indexSpecification) {
        Transaction transaction = this.graph.beginTx();
        try {
            IndexRepresentation indexRepresentation = super.createNodeIndex(indexSpecification);
            transaction.success();
            IndexRepresentation indexRepresentation2 = indexRepresentation;
            return indexRepresentation2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipRepresentation createRelationship(long startNodeId, long endNodeId, String type, Map<String, Object> properties) throws StartNodeNotFoundException, EndNodeNotFoundException, PropertyValueException {
        Transaction transaction = this.graph.beginTx();
        try {
            RelationshipRepresentation relationshipRepresentation = super.createRelationship(startNodeId, endNodeId, type, properties);
            transaction.success();
            RelationshipRepresentation relationshipRepresentation2 = relationshipRepresentation;
            return relationshipRepresentation2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipRepresentation getRelationship(long relationshipId) throws RelationshipNotFoundException {
        Transaction transaction = this.graph.beginTx();
        try {
            RelationshipRepresentation relationship = super.getRelationship(relationshipId);
            transaction.success();
            RelationshipRepresentation relationshipRepresentation = relationship;
            return relationshipRepresentation;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRelationship(long relationshipId) throws RelationshipNotFoundException {
        Transaction transaction = this.graph.beginTx();
        try {
            super.deleteRelationship(relationshipId);
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListRepresentation getNodeRelationships(long nodeId, DatabaseActions.RelationshipDirection direction, Collection<String> types) throws NodeNotFoundException {
        Transaction transaction = this.graph.beginTx();
        try {
            ListRepresentation nodeRelationships = super.getNodeRelationships(nodeId, direction, types);
            transaction.success();
            ListRepresentation listRepresentation = nodeRelationships;
            return listRepresentation;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllRelationshipProperties(long relationshipId, Map<String, Object> properties) throws PropertyValueException, RelationshipNotFoundException {
        Transaction transaction = this.graph.beginTx();
        try {
            super.setAllRelationshipProperties(relationshipId, properties);
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelationshipProperty(long relationshipId, String key, Object value) throws PropertyValueException, RelationshipNotFoundException {
        Transaction transaction = this.graph.beginTx();
        try {
            super.setRelationshipProperty(relationshipId, key, value);
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRelationshipProperties(long relationshipId) throws RelationshipNotFoundException, PropertyValueException {
        Transaction transaction = this.graph.beginTx();
        try {
            super.removeAllRelationshipProperties(relationshipId);
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRelationshipProperty(long relationshipId, String key) throws RelationshipNotFoundException, NoSuchPropertyException {
        Transaction transaction = this.graph.beginTx();
        try {
            super.removeRelationshipProperty(relationshipId, key);
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexedEntityRepresentation addToNodeIndex(String indexName, String key, String value, long nodeId) {
        Transaction transaction = this.graph.beginTx();
        try {
            IndexedEntityRepresentation indexedEntityRepresentation = super.addToNodeIndex(indexName, key, value, nodeId);
            transaction.success();
            IndexedEntityRepresentation indexedEntityRepresentation2 = indexedEntityRepresentation;
            return indexedEntityRepresentation2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromNodeIndex(String indexName, String key, String value, long id) {
        Transaction transaction = this.graph.beginTx();
        try {
            super.removeFromNodeIndex(indexName, key, value, id);
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromNodeIndexNoValue(String indexName, String key, long id) {
        Transaction transaction = this.graph.beginTx();
        try {
            super.removeFromNodeIndexNoValue(indexName, key, id);
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromNodeIndexNoKeyValue(String indexName, long id) {
        Transaction transaction = this.graph.beginTx();
        try {
            super.removeFromNodeIndexNoKeyValue(indexName, id);
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathRepresentation findSinglePath(long startId, long endId, Map<String, Object> map) {
        Transaction transaction = this.graph.beginTx();
        try {
            PathRepresentation singlePath = super.findSinglePath(startId, endId, map);
            transaction.success();
            PathRepresentation pathRepresentation = singlePath;
            return pathRepresentation;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListRepresentation getNodesWithLabel(String labelName, Map<String, Object> properties) {
        Transaction transaction = this.graph.beginTx();
        try {
            ListRepresentation nodesWithLabel = super.getNodesWithLabel(labelName, properties);
            transaction.success();
            ListRepresentation listRepresentation = nodesWithLabel;
            return listRepresentation;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexDefinitionRepresentation createSchemaIndex(String labelName, Iterable<String> propertyKey) {
        Transaction transaction = this.graph.beginTx();
        try {
            IndexDefinitionRepresentation indexDefinitionRepresentation = super.createSchemaIndex(labelName, propertyKey);
            transaction.success();
            IndexDefinitionRepresentation indexDefinitionRepresentation2 = indexDefinitionRepresentation;
            return indexDefinitionRepresentation2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropSchemaIndex(String labelName, String propertyKey) {
        Transaction transaction = this.graph.beginTx();
        try {
            boolean result = super.dropSchemaIndex(labelName, propertyKey);
            transaction.success();
            boolean bl = result;
            return bl;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintDefinitionRepresentation createPropertyUniquenessConstraint(String labelName, Iterable<String> propertyKeys) {
        Transaction transaction = this.graph.beginTx();
        try {
            ConstraintDefinitionRepresentation constraintDefinitionRepresentation = super.createPropertyUniquenessConstraint(labelName, propertyKeys);
            transaction.success();
            ConstraintDefinitionRepresentation constraintDefinitionRepresentation2 = constraintDefinitionRepresentation;
            return constraintDefinitionRepresentation2;
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropPropertyUniquenessConstraint(String labelName, Iterable<String> propertyKeys) {
        Transaction transaction = this.graph.beginTx();
        try {
            boolean result = super.dropPropertyUniquenessConstraint(labelName, propertyKeys);
            transaction.success();
            boolean bl = result;
            return bl;
        }
        finally {
            transaction.finish();
        }
    }
}

