/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.server.security.auth.Authentication;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.Privileges;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.auth.exception.TooManyAuthenticationAttemptsException;

public class AuthenticationTest {
    @Test
    public void shouldSetPassword() throws Exception {
        InMemoryUserRepository users = new InMemoryUserRepository();
        Authentication auth = new Authentication((Clock)new FakeClock(), (UserRepository)users, 1);
        users.save(new User("jake", Privileges.ADMIN));
        auth.setPassword("jake", "hello, world!");
        Assert.assertTrue((boolean)auth.authenticate("jake", "hello, world!"));
        junit.framework.Assert.assertFalse((boolean)auth.authenticate("jake", "goodbye, world!"));
    }

    @Test
    public void shouldSlowRequestRateOnMultipleFailedAttempts() throws Exception {
        FakeClock clock = new FakeClock();
        Authentication auth = new Authentication((Clock)clock, (UserRepository)new InMemoryUserRepository(), 3);
        auth.authenticate("wrong", "wrong");
        auth.authenticate("wrong", "wrong");
        auth.authenticate("wrong", "wrong");
        try {
            auth.authenticate("wrong", "wrong");
            TestCase.fail((String)"Shouldn't have been allowed");
        }
        catch (TooManyAuthenticationAttemptsException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Too many failed authentication requests. Please try again in 5 seconds."));
        }
        clock.forward(6L, TimeUnit.SECONDS);
        junit.framework.Assert.assertFalse((boolean)auth.authenticate("wrong", "wrong"));
    }

    @Test
    public void handlesMalformedAuthentication() throws Exception {
        InMemoryUserRepository users = new InMemoryUserRepository();
        Authentication auth = new Authentication((Clock)new FakeClock(), (UserRepository)users, 50);
        users.save(new User("jake", Privileges.ADMIN));
        auth.setPassword("jake", "helo");
        junit.framework.Assert.assertFalse((boolean)auth.authenticate("jake", "hello, world!"));
        junit.framework.Assert.assertFalse((boolean)auth.authenticate(null, "hello, world!"));
        junit.framework.Assert.assertFalse((boolean)auth.authenticate("jake", null));
        junit.framework.Assert.assertFalse((boolean)auth.authenticate(null, null));
        junit.framework.Assert.assertFalse((boolean)auth.authenticate("no such user", null));
    }
}

