/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.server.security.auth.Credentials;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.Privileges;
import org.neo4j.server.security.auth.User;
import org.neo4j.test.EphemeralFileSystemRule;

public class FileUserRepositoryTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();

    @Test
    public void shouldStoreAndRetriveUsers() throws Exception {
        FileUserRepository users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), new File("dbms/auth.db"));
        User user = new User("jake", "af123", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        users.save(user);
        User result = users.get(user.name());
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)user));
    }

    @Test
    public void shouldPersistUsers() throws Throwable {
        FileUserRepository users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), new File("dbms/auth.db"));
        User user = new User("jake", "af123", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        users.save(user);
        users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), new File("dbms/auth.db"));
        users.start();
        User result = users.get(user.name());
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)user));
    }

    @Test
    public void shouldNotAllowComplexNames() throws Exception {
        FileUserRepository users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), new File("dbms/auth.db"));
        Assert.assertTrue((boolean)users.isValidName("neo4j"));
        Assert.assertTrue((boolean)users.isValidName("johnosbourne"));
        Assert.assertTrue((boolean)users.isValidName("john_osbourne"));
        Assert.assertFalse((boolean)users.isValidName(":"));
        Assert.assertFalse((boolean)users.isValidName(""));
        Assert.assertFalse((boolean)users.isValidName("john osbourne"));
        Assert.assertFalse((boolean)users.isValidName("john:osbourne"));
    }

    @Test
    public void shouldRecoverIfCrashedDuringWrite() throws Throwable {
        File dbFile = new File("dbms/auth.db");
        FileUserRepository users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), dbFile);
        User user = new User("jake", "af123", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        users.save(user);
        File tempFile = new File(dbFile.getAbsolutePath() + ".tmp");
        this.fsRule.get().renameFile(dbFile, tempFile);
        users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), dbFile);
        users.start();
        Assert.assertFalse((boolean)this.fsRule.get().fileExists(tempFile));
        Assert.assertTrue((boolean)this.fsRule.get().fileExists(dbFile));
        MatcherAssert.assertThat((Object)users.get(user.name()), (Matcher)CoreMatchers.equalTo((Object)user));
    }
}

