/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.lang.annotation.Annotation;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.clirr.core.ApiDifference;
import org.codehaus.mojo.clirr.ApiDifferenceFilter;
import org.codehaus.mojo.clirr.ExternallyInvokedFilter;
import org.codehaus.mojo.clirr.JavaTypeRepository;
import org.codehaus.mojo.clirr.MessageCodeFilter;

public class AdaptedInterfacesFilter
implements ApiDifferenceFilter {
    private Set<String> annotations;
    private JavaTypeRepository originalClasses;
    private MessageCodeFilter adaptedInterfaceFilter = ExternallyInvokedFilter.EXTERNALLY_INVOKED_FILTER;

    public AdaptedInterfacesFilter(Set<String> adapterAnnotations, JavaTypeRepository origClasses) {
        this.annotations = adapterAnnotations;
        this.originalClasses = origClasses;
    }

    @Override
    public boolean shouldInclude(ApiDifference apiDiff) {
        try {
            if (apiDiff.getAffectedMethod() != null) {
                Class<?> clazz = this.originalClasses.get(apiDiff.getAffectedClass());
                for (Annotation annotation : clazz.getAnnotations()) {
                    if (!this.annotations.contains(annotation.annotationType().getName())) continue;
                    return this.adaptedInterfaceFilter.shouldInclude(apiDiff);
                }
                return true;
            }
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }
}

