/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.util.List;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.DiffListener;
import net.sf.clirr.core.Severity;

public class DelegatingListener
implements DiffListener {
    private final List listeners;
    private final Severity minSeverity;

    public DelegatingListener(List listeners, Severity minSeverity) {
        this.listeners = listeners;
        this.minSeverity = minSeverity;
    }

    public void start() {
        for (DiffListener listener : this.listeners) {
            listener.start();
        }
    }

    public void reportDiff(ApiDifference apiDifference) {
        if (this.minSeverity == null || this.minSeverity.compareTo((Object)apiDifference.getMaximumSeverity()) <= 0) {
            for (DiffListener listener : this.listeners) {
                listener.reportDiff(apiDifference);
            }
        }
    }

    public void stop() {
        for (DiffListener listener : this.listeners) {
            listener.stop();
        }
    }
}

