/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.Checker;
import net.sf.clirr.core.ClassFilter;
import net.sf.clirr.core.DiffListener;
import net.sf.clirr.core.DiffListenerAdapter;
import net.sf.clirr.core.PlainDiffListener;
import net.sf.clirr.core.Severity;
import net.sf.clirr.core.XmlDiffListener;
import net.sf.clirr.core.internal.bcel.BcelTypeArrayBuilder;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.mojo.clirr.AbstractClirrMojo;
import org.codehaus.mojo.clirr.ArtifactSpecification;
import org.codehaus.mojo.clirr.ClirrClassFilter;
import org.codehaus.mojo.clirr.ClirrDiffListener;
import org.codehaus.mojo.clirr.DelegatingListener;
import org.codehaus.mojo.clirr.JavaTypeRepository;
import org.codehaus.mojo.clirr.LogDiffListener;
import org.codehaus.mojo.clirr.MissingPreviousException;
import org.codehaus.plexus.i18n.I18N;

public class ClirrArbitraryCheckMojo
extends AbstractClirrMojo {
    private boolean failOnError;
    private boolean failOnWarning;
    private I18N i18n;
    protected ArtifactSpecification[] oldComparisonArtifacts;
    protected ArtifactSpecification[] newComparisonArtifacts;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        ClirrDiffListener listener;
        if (this.oldComparisonArtifacts == null || this.oldComparisonArtifacts.length == 0) {
            this.getLog().info((CharSequence)"Missing required oldComparisonArtifacts");
        }
        if (this.newComparisonArtifacts == null || this.newComparisonArtifacts.length == 0) {
            this.getLog().info((CharSequence)"Missing required newComparisonArtifacts");
        }
        try {
            listener = this.executeClirr(Severity.INFO);
        }
        catch (MissingPreviousException e) {
            this.getLog().debug((Throwable)((Object)e));
            this.getLog().info((CharSequence)"No previous version was found. Use 'comparisonArtifacts' for explicit configuration if you think this is wrong.");
            return;
        }
        Locale locale = Locale.getDefault();
        int errorCount = listener.getSeverityCount(Severity.ERROR);
        if (this.failOnError && errorCount > 0) {
            String message;
            this.log(listener, Severity.ERROR);
            if (errorCount > 1) {
                Object[] args = new String[]{String.valueOf(errorCount)};
                message = this.i18n.format("clirr-report", locale, "check.clirr.failure.errors", args);
            } else {
                message = this.i18n.getString("clirr-report", locale, "check.clirr.failure.error");
            }
            throw new MojoFailureException(message);
        }
        int warningCount = listener.getSeverityCount(Severity.WARNING);
        if (this.failOnWarning && errorCount > 0) {
            String message;
            this.log(listener, Severity.WARNING);
            if (errorCount > 1) {
                Object[] args = new String[]{String.valueOf(errorCount)};
                message = this.i18n.format("clirr-report", locale, "check.clirr.failure.warnings", args);
            } else {
                message = this.i18n.getString("clirr-report", locale, "check.clirr.failure.warning");
            }
            throw new MojoFailureException(message);
        }
        int infoCount = listener.getSeverityCount(Severity.INFO);
        Object[] args = new String[]{String.valueOf(errorCount), String.valueOf(warningCount), String.valueOf(infoCount)};
        this.getLog().info((CharSequence)this.i18n.format("clirr-report", locale, "check.clirr.success", args));
    }

    private void log(ClirrDiffListener listener, Severity severity) {
        if (!this.logResults) {
            LogDiffListener l = new LogDiffListener(this.getLog());
            for (ApiDifference difference : listener.getApiDifferences()) {
                if (!difference.getMaximumSeverity().equals(severity)) continue;
                l.reportDiff(difference);
            }
        }
    }

    protected JavaTypeRepository resolveClasses(ArtifactSpecification[] artifacts, ClassFilter classFilter) throws MojoFailureException, MojoExecutionException {
        Set artifactSet = this.resolveArtifacts(artifacts);
        Artifact a = null;
        for (Artifact artifact : artifactSet) {
            if (a == null) {
                a = artifact;
            }
            this.getLog().debug((CharSequence)("Comparing to " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getClassifier() + ":" + artifact.getType()));
        }
        try {
            for (Artifact artifact : artifactSet) {
                this.resolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
            }
            List dependencies = this.getTransitiveDependencies(artifactSet);
            ClassLoader origDepCL = ClirrArbitraryCheckMojo.createClassLoader(dependencies, artifactSet);
            File[] files = new File[artifactSet.size()];
            int i = 0;
            for (Artifact artifact : artifactSet) {
                files[i++] = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(artifact));
            }
            return new JavaTypeRepository(BcelTypeArrayBuilder.createClassSet((File[])files, (ClassLoader)origDepCL, (ClassFilter)classFilter), origDepCL);
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Failed to build project for previous artifact: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MissingPreviousException("Error resolving previous version: " + e.getMessage(), e);
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Error finding previous version: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error creating classloader for previous version's classes", (Exception)e);
        }
    }

    @Override
    protected ClirrDiffListener executeClirr(Severity minSeverity) throws MojoExecutionException, MojoFailureException {
        ClirrClassFilter classFilter = new ClirrClassFilter(this.includes, this.excludes);
        JavaTypeRepository origClasses = this.resolveClasses(this.oldComparisonArtifacts, classFilter);
        JavaTypeRepository currentClasses = this.resolveClasses(this.newComparisonArtifacts, classFilter);
        ClirrDiffListener listener = this.createDiffListener(origClasses, currentClasses);
        Checker checker = new Checker();
        ArrayList<DiffListenerAdapter> listeners = new ArrayList<DiffListenerAdapter>();
        listeners.add(listener);
        if (this.xmlOutputFile != null) {
            try {
                listeners.add((DiffListenerAdapter)new XmlDiffListener(this.xmlOutputFile.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error adding '" + this.xmlOutputFile + "' for output: " + e.getMessage(), (Exception)e);
            }
        }
        if (this.textOutputFile != null) {
            try {
                listeners.add((DiffListenerAdapter)new PlainDiffListener(this.textOutputFile.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error adding '" + this.textOutputFile + "' for output: " + e.getMessage(), (Exception)e);
            }
        }
        if (this.logResults) {
            listeners.add(new LogDiffListener(this.getLog()));
        }
        checker.addDiffListener((DiffListener)new DelegatingListener(listeners, minSeverity));
        checker.reportDiffs(origClasses.getRawJavaTypes(), currentClasses.getRawJavaTypes());
        return listener;
    }
}

