/*
 * Decompiled with CFR 0.152.
 */
package net.grinder;

import net.grinder.AgentController;
import net.grinder.engine.agent.Agent;
import net.grinder.util.ListenerHelper;
import net.grinder.util.ListenerSupport;
import net.grinder.util.thread.Condition;
import org.ngrinder.common.util.ExceptionUtils;
import org.ngrinder.common.util.ThreadUtils;
import org.ngrinder.infra.AgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentControllerDaemon
implements Agent {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"agent controller daemon");
    private static final int LOG_FREQUENCY = 5;
    private final Condition m_eventSyncCondition = new Condition();
    private final AgentController agentController;
    private final ListenerSupport<AgentControllerShutDownListener> m_listeners = ListenerHelper.create();
    private Thread thread;
    private boolean forceShutdown = false;
    private long count = 0L;

    public AgentControllerDaemon(AgentConfig agentConfig) {
        try {
            this.agentController = new AgentController(this.m_eventSyncCondition, agentConfig);
        }
        catch (RuntimeException e) {
            throw ExceptionUtils.processException("Exception occurred while initiating the agent controller daemon", e);
        }
    }

    public void run() {
        this.thread = new Thread(() -> {
            while (true) {
                try {
                    if (this.count++ % 5L == 0L) {
                        LOGGER.info("The agent controller daemon is started.");
                    }
                    this.getAgentController().run();
                    this.getListeners().apply(AgentControllerShutDownListener::shutdownAgentController);
                }
                catch (Exception e) {
                    LOGGER.info("Agent controller daemon is crashed. {}", (Object)e.getMessage());
                    LOGGER.debug("The error detail is  ", (Throwable)e);
                }
                if (this.isForceShutdown()) break;
                ThreadUtils.sleep(2000L);
            }
            this.setForceShutdown(false);
        }, "Agent Controller Thread");
        this.thread.start();
    }

    public ListenerSupport<AgentControllerShutDownListener> getListeners() {
        return this.m_listeners;
    }

    public void shutdown() {
        try {
            this.setForceShutdown(true);
            this.agentController.shutdown();
            if (this.thread != null) {
                ThreadUtils.stopQuietly(this.thread, "Agent controller thread was not stopped. Stop by force.");
                this.thread = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AgentController getAgentController() {
        return this.agentController;
    }

    private boolean isForceShutdown() {
        return this.forceShutdown;
    }

    private synchronized void setForceShutdown(boolean force) {
        this.forceShutdown = force;
    }

    public static interface AgentControllerShutDownListener {
        public void shutdownAgentController();
    }
}

