/*
 * Decompiled with CFR 0.152.
 */
package net.grinder;

import net.grinder.common.GrinderException;
import net.grinder.common.GrinderProperties;
import net.grinder.engine.agent.Agent;
import net.grinder.engine.agent.AgentImplementationEx;
import net.grinder.util.ListenerSupport;
import org.apache.commons.lang.StringUtils;
import org.ngrinder.common.util.ExceptionUtils;
import org.ngrinder.common.util.ThreadUtils;
import org.ngrinder.infra.AgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentDaemon
implements Agent {
    private volatile AgentImplementationEx agent;
    private Thread thread;
    private GrinderProperties properties;
    private final ListenerSupport<AgentShutDownListener> m_listeners = new ListenerSupport();
    private boolean forceShutdown = false;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"agent daemon");
    private final AgentConfig m_agentConfig;

    public AgentDaemon(AgentConfig agentConfig) {
        this.m_agentConfig = agentConfig;
        try {
            this.properties = new GrinderProperties(GrinderProperties.DEFAULT_PROPERTIES);
        }
        catch (GrinderException e) {
            throw ExceptionUtils.processException("Exception occurred while creating agent daemon", e);
        }
    }

    public synchronized AgentImplementationEx setAgent(AgentImplementationEx agent) {
        this.agent = agent;
        return this.agent;
    }

    public void run() {
        this.run(null, 6372);
    }

    public void run(int consolePort) {
        this.run(null, consolePort);
    }

    public void run(GrinderProperties grinderProperties) {
        this.properties = grinderProperties;
        this.run(null, 0);
    }

    public void run(String consoleHost, int consolePort) {
        if (StringUtils.isNotEmpty((String)consoleHost)) {
            this.getGrinderProperties().setProperty("grinder.consoleHost", consoleHost);
        }
        if (consolePort > 0) {
            this.getGrinderProperties().setInt("grinder.consolePort", consolePort);
        }
        this.thread = new Thread((Runnable)new AgentThreadRunnable(), "Agent daemon connecting to port " + this.getGrinderProperties().getInt("grinder.consolePort", 0));
        this.thread.setDaemon(true);
        this.thread.start();
        LOGGER.info("{} is started.", (Object)this.thread.getName());
    }

    private GrinderProperties getGrinderProperties() {
        return this.properties;
    }

    public ListenerSupport<AgentShutDownListener> getListeners() {
        return this.m_listeners;
    }

    public void resetListeners() {
        ListenerSupport backup = new ListenerSupport();
        this.getListeners().apply(arg_0 -> ((ListenerSupport)backup).add(arg_0));
        backup.apply(listener -> this.getListeners().remove(listener));
    }

    public void addListener(AgentShutDownListener listener) {
        this.m_listeners.add((Object)listener);
    }

    public void shutdown() {
        try {
            this.forceShutdown = true;
            if (this.agent != null) {
                this.agent.shutdown();
            }
            ThreadUtils.stopQuietly(this.thread, "Agent daemon is not stopped. So stop by force");
            this.thread = null;
        }
        catch (Exception e) {
            throw ExceptionUtils.processException("Exception occurred while shutting down the agent daemon", e);
        }
    }

    private boolean isForceShutdown() {
        return this.forceShutdown;
    }

    private void setForceShutdown(boolean force) {
        this.forceShutdown = force;
    }

    public static interface AgentShutDownListener {
        public void shutdownAgent();
    }

    class AgentThreadRunnable
    implements Runnable {
        AgentThreadRunnable() {
        }

        @Override
        public void run() {
            try {
                AgentDaemon.this.setAgent(new AgentImplementationEx(LOGGER, AgentDaemon.this.m_agentConfig)).run(AgentDaemon.this.getGrinderProperties());
            }
            catch (Exception e) {
                LOGGER.error("While running an agent thread, an error occurred", (Throwable)e);
            }
            AgentDaemon.this.getListeners().apply(AgentShutDownListener::shutdownAgent);
            if (AgentDaemon.this.isForceShutdown()) {
                AgentDaemon.this.setForceShutdown(false);
            }
        }
    }
}

