/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console;

import java.util.Timer;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.console.common.ErrorHandler;
import net.grinder.console.common.ErrorQueue;
import net.grinder.console.common.Resources;
import net.grinder.console.communication.AcceptDistFilesDigestListener;
import net.grinder.console.communication.ConsoleCommunication;
import net.grinder.console.communication.ConsoleCommunicationImplementationEx;
import net.grinder.console.communication.DistributionControlImplementation;
import net.grinder.console.communication.ProcessControlImplementation;
import net.grinder.console.communication.server.DispatchClientCommands;
import net.grinder.console.distribution.FileDistributionImplementation;
import net.grinder.console.distribution.WireFileDistribution;
import net.grinder.console.model.ConsoleCommunicationSetting;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.console.model.SampleModel;
import net.grinder.console.model.SampleModelImplementationEx;
import net.grinder.console.model.SampleModelViews;
import net.grinder.console.model.SampleModelViewsImplementation;
import net.grinder.console.synchronisation.WireDistributedBarriers;
import net.grinder.engine.communication.DistFilesDigestMessage;
import net.grinder.engine.console.ErrorHandlerImplementation;
import net.grinder.messages.console.RegisterExpressionViewMessage;
import net.grinder.messages.console.RegisterTestsMessage;
import net.grinder.messages.console.ReportStatisticsMessage;
import net.grinder.statistics.StatisticsServicesImplementation;
import net.grinder.util.ListenerSupport;
import net.grinder.util.StandardTimeAuthority;
import net.grinder.util.thread.Condition;
import org.apache.commons.lang.StringUtils;
import org.ngrinder.common.util.ExceptionUtils;
import org.ngrinder.common.util.NoOp;
import org.picocontainer.ComponentFactory;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.behaviors.Caching;
import org.picocontainer.parameters.ComponentParameter;
import org.picocontainer.parameters.ConstantParameter;
import org.slf4j.Logger;

public class ConsoleFoundationEx {
    private final MutablePicoContainer m_container;
    private final Timer m_timer;
    private boolean m_shutdown = false;
    private final Condition m_eventSyncCondition;
    private final ListenerSupport<AcceptDistFilesDigestListener> m_distFilesDigestAcceptListener = new ListenerSupport();

    public ConsoleFoundationEx(Resources resources, Logger logger, ConsoleProperties properties, ConsoleCommunicationSetting consoleCommunicationSetting, Condition eventSyncCondition) {
        this.m_eventSyncCondition = eventSyncCondition;
        this.m_container = new DefaultPicoContainer((ComponentFactory)new Caching());
        this.m_container.addComponent((Object)logger);
        this.m_container.addComponent((Object)resources);
        this.m_container.addComponent((Object)properties);
        this.m_container.addComponent((Object)StatisticsServicesImplementation.getInstance());
        this.m_container.addComponent((Object)new StandardTimeAuthority());
        this.m_container.addComponent((Object)consoleCommunicationSetting);
        this.m_container.addComponent(SampleModelImplementationEx.class);
        this.m_container.addComponent(SampleModelViewsImplementation.class);
        this.m_container.addComponent(ConsoleCommunicationImplementationEx.class);
        this.m_container.addComponent(DistributionControlImplementation.class);
        this.m_container.addComponent(ProcessControlImplementation.class);
        this.m_timer = new Timer(true);
        this.m_container.addComponent((Object)this.m_timer);
        this.m_container.addComponent(FileDistributionImplementation.class, FileDistributionImplementation.class, new Parameter[]{new ComponentParameter(DistributionControlImplementation.class), new ComponentParameter(ProcessControlImplementation.class), new ConstantParameter((Object)properties.getDistributionDirectory()), new ConstantParameter((Object)properties.getDistributionFileFilterPattern())});
        this.m_container.addComponent(DispatchClientCommands.class);
        this.m_container.addComponent(WireFileDistribution.class);
        this.m_container.addComponent(WireMessageDispatch.class, WireMessageDispatch.class, new Parameter[]{new ComponentParameter(ConsoleCommunicationImplementationEx.class), new ComponentParameter(SampleModelImplementationEx.class), new ComponentParameter(SampleModelViewsImplementation.class), new ComponentParameter(DispatchClientCommands.class), new ConstantParameter(this.m_distFilesDigestAcceptListener)});
        this.m_container.addComponent(WireDistributedBarriers.class);
        this.m_container.addComponent(ErrorQueue.class);
        ErrorQueue errorQueue = (ErrorQueue)this.m_container.getComponent(ErrorQueue.class);
        errorQueue.setErrorHandler((ErrorHandler)new ErrorHandlerImplementation(logger));
    }

    public <T> T getComponent(Class<T> componentType) {
        return (T)this.m_container.getComponent(componentType);
    }

    public void shutdown() {
        this.m_shutdown = true;
        ((ConsoleCommunication)this.m_container.getComponent(ConsoleCommunication.class)).shutdown();
        try {
            this.m_timer.cancel();
        }
        catch (Exception e) {
            NoOp.noOp();
        }
        if (this.m_container.getLifecycleState().isStarted()) {
            this.m_container.stop();
        }
    }

    public void addDistFilesDigestAcceptListener(AcceptDistFilesDigestListener acceptDistFilesDigestListener) {
        this.m_distFilesDigestAcceptListener.add((Object)acceptDistFilesDigestListener);
    }

    private String getConsoleInfo() {
        ConsoleProperties consoleProperties = (ConsoleProperties)this.m_container.getComponent(ConsoleProperties.class);
        return StringUtils.defaultIfBlank((String)consoleProperties.getConsoleHost(), (String)"localhost") + ":" + consoleProperties.getConsolePort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.m_shutdown) {
            throw ExceptionUtils.processException("console can not run because it's shutdowned");
        }
        this.m_container.start();
        ConsoleCommunication communication = (ConsoleCommunication)this.m_container.getComponent(ConsoleCommunication.class);
        this.m_container.getComponent(WireMessageDispatch.class);
        this.m_container.getComponent(WireFileDistribution.class);
        this.m_container.getComponent(WireDistributedBarriers.class);
        ((Logger)this.m_container.getComponent(Logger.class)).info("console {} has been started", (Object)this.getConsoleInfo());
        Condition condition = this.m_eventSyncCondition;
        synchronized (condition) {
            this.m_eventSyncCondition.notifyAll();
        }
        while (communication.processOneMessage()) {
            NoOp.noOp();
        }
    }

    public MutablePicoContainer getContainer() {
        return this.m_container;
    }

    public static class WireMessageDispatch {
        public WireMessageDispatch(ConsoleCommunication communication, final SampleModel model, final SampleModelViews sampleModelViews, DispatchClientCommands dispatchClientCommands, final ListenerSupport<AcceptDistFilesDigestListener> distFilesDigestAcceptListener) {
            MessageDispatchRegistry messageDispatchRegistry = communication.getMessageDispatchRegistry();
            messageDispatchRegistry.set(RegisterTestsMessage.class, (MessageDispatchRegistry.Handler)new MessageDispatchRegistry.AbstractHandler<RegisterTestsMessage>(){

                public void handle(RegisterTestsMessage message) {
                    model.registerTests(message.getTests());
                }
            });
            messageDispatchRegistry.set(ReportStatisticsMessage.class, (MessageDispatchRegistry.Handler)new MessageDispatchRegistry.AbstractHandler<ReportStatisticsMessage>(){

                public void handle(ReportStatisticsMessage message) {
                    model.addTestReport(message.getStatisticsDelta());
                }
            });
            messageDispatchRegistry.set(RegisterExpressionViewMessage.class, (MessageDispatchRegistry.Handler)new MessageDispatchRegistry.AbstractHandler<RegisterExpressionViewMessage>(){

                public void handle(RegisterExpressionViewMessage message) {
                    sampleModelViews.registerStatisticExpression(message.getExpressionView());
                }
            });
            messageDispatchRegistry.set(DistFilesDigestMessage.class, (MessageDispatchRegistry.Handler)new MessageDispatchRegistry.AbstractHandler<DistFilesDigestMessage>(){

                public void handle(final DistFilesDigestMessage message) {
                    distFilesDigestAcceptListener.apply((ListenerSupport.Informer)new ListenerSupport.Informer<AcceptDistFilesDigestListener>(){

                        public void inform(AcceptDistFilesDigestListener listener) {
                            listener.onAcceptDistFilesDigestListener(message.getDistFilesDigest());
                        }
                    });
                }
            });
            dispatchClientCommands.registerMessageHandlers(messageDispatchRegistry);
        }
    }
}

