/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import net.grinder.common.GrinderBuild;
import net.grinder.common.GrinderException;
import net.grinder.common.GrinderProperties;
import net.grinder.common.processidentity.AgentIdentity;
import net.grinder.communication.Address;
import net.grinder.communication.ClientReceiver;
import net.grinder.communication.ClientSender;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.ConnectionType;
import net.grinder.communication.Connector;
import net.grinder.communication.FanOutStreamSender;
import net.grinder.communication.IgnoreShutdownSender;
import net.grinder.communication.Message;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.communication.MessageDispatchSender;
import net.grinder.communication.MessagePump;
import net.grinder.communication.Receiver;
import net.grinder.communication.Sender;
import net.grinder.communication.TeeSender;
import net.grinder.engine.agent.Agent;
import net.grinder.engine.agent.AgentIdentityImplementation;
import net.grinder.engine.agent.DebugThreadWorkerFactory;
import net.grinder.engine.agent.FileStore;
import net.grinder.engine.agent.ProcessWorkerFactory;
import net.grinder.engine.agent.PropertyBuilder;
import net.grinder.engine.agent.WorkerFactory;
import net.grinder.engine.agent.WorkerLauncher;
import net.grinder.engine.agent.WorkerProcessCommandLine;
import net.grinder.engine.common.ConnectorFactory;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.common.ScriptLocation;
import net.grinder.engine.communication.ConsoleListener;
import net.grinder.engine.communication.DistFilesDigestMessage;
import net.grinder.lang.AbstractLanguageHandler;
import net.grinder.lang.Lang;
import net.grinder.messages.agent.StartGrinderMessage;
import net.grinder.messages.console.AgentAddress;
import net.grinder.messages.console.AgentProcessReportMessage;
import net.grinder.util.AbstractGrinderClassPathProcessor;
import net.grinder.util.Directory;
import net.grinder.util.NetworkUtils;
import net.grinder.util.thread.Condition;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.ngrinder.common.constants.AgentConstants;
import org.ngrinder.common.util.NoOp;
import org.ngrinder.infra.AgentConfig;
import org.slf4j.Logger;

public class AgentImplementationEx
implements Agent,
AgentConstants {
    private final Logger m_logger;
    private final boolean m_proceedWithoutConsole;
    private Timer m_timer;
    private final Condition m_eventSynchronisation = new Condition();
    private final AgentIdentityImplementation m_agentIdentity;
    private final ConsoleListener m_consoleListener;
    private FanOutStreamSender m_fanOutStreamSender;
    private final ConnectorFactory m_connectorFactory = new ConnectorFactory(ConnectionType.AGENT);
    private WorkerLauncher m_workerLauncherForShutdown = null;
    private volatile FileStore m_fileStore;
    private final AgentConfig m_agentConfig;
    public static final String GRINDER_PROP_TEST_ID = "grinder.test.id";

    public AgentImplementationEx(Logger logger, AgentConfig agentConfig, boolean proceedWithoutConsole) {
        this.m_logger = logger;
        this.m_agentConfig = agentConfig;
        this.m_proceedWithoutConsole = proceedWithoutConsole;
        this.m_consoleListener = new ConsoleListener(this.m_eventSynchronisation, this.m_logger);
        this.m_agentIdentity = new AgentIdentityImplementation(NetworkUtils.getLocalHostName());
    }

    public AgentImplementationEx(Logger logger, AgentConfig agentConfig) {
        this(logger, agentConfig, false);
    }

    public void run() throws GrinderException {
        this.run(new GrinderProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(GrinderProperties grinderProperties) throws GrinderException {
        block44: {
            block43: {
                StartGrinderMessage startMessage = null;
                ConsoleCommunication consoleCommunication = null;
                this.m_fanOutStreamSender = new FanOutStreamSender(3);
                this.m_timer = new Timer(false);
                int connectionPort = grinderProperties.getInt("grinder.consolePort", 0);
                try {
                    while (true) {
                        GrinderProperties properties;
                        this.m_logger.info(GrinderBuild.getName());
                        ScriptLocation script = null;
                        do {
                            properties = this.createAndMergeProperties(grinderProperties, startMessage != null ? startMessage.getProperties() : null);
                            if (this.m_agentConfig.isConnectionMode()) {
                                properties.setProperty("grinder.consoleHost", NetworkUtils.DEFAULT_LOCAL_HOST_ADDRESS);
                                properties.setInt("grinder.consolePort", connectionPort);
                            } else {
                                properties.setProperty("grinder.consoleHost", this.m_agentConfig.getControllerIP());
                            }
                            this.m_agentIdentity.setName(this.m_agentConfig.getAgentHostID());
                            Connector connector = this.m_connectorFactory.create(properties);
                            if (consoleCommunication != null && !consoleCommunication.getConnector().equals(connector)) {
                                this.shutdownConsoleCommunication(consoleCommunication);
                                consoleCommunication = null;
                            }
                            if (consoleCommunication == null && connector != null) {
                                try {
                                    consoleCommunication = new ConsoleCommunication(connector, grinderProperties.getProperty("grinder.user", "_default"));
                                    consoleCommunication.start();
                                    this.m_logger.info("Connect to console at {}", (Object)connector.getEndpointAsString());
                                }
                                catch (CommunicationException e) {
                                    if (this.m_proceedWithoutConsole) {
                                        this.m_logger.warn("{}, proceeding without the console; set grinder.useConsole=false to disable this warning.", (Object)e.getMessage());
                                    }
                                    this.m_logger.error(e.getMessage());
                                    if (this.m_timer != null) {
                                        this.m_timer.cancel();
                                        this.m_timer = null;
                                    }
                                    this.shutdownConsoleCommunication(consoleCommunication);
                                    if (this.m_fanOutStreamSender != null) {
                                        this.m_fanOutStreamSender.shutdown();
                                        this.m_fanOutStreamSender = null;
                                    }
                                    this.m_consoleListener.shutdown();
                                    this.m_logger.info("Test shuts down.");
                                    return;
                                }
                            }
                            if (consoleCommunication != null && startMessage == null) {
                                this.m_logger.info("Waiting for console signal");
                                this.m_consoleListener.waitForMessage();
                                if (!this.m_consoleListener.received(1)) break;
                                startMessage = this.m_consoleListener.getLastStartGrinderMessage();
                                continue;
                            }
                            if (startMessage != null) {
                                GrinderProperties messageProperties = startMessage.getProperties();
                                Directory fileStoreDirectory = this.m_fileStore.getDirectory();
                                messageProperties.setAssociatedFile(fileStoreDirectory.getFile(messageProperties.getAssociatedFile()));
                                File consoleScript = messageProperties.resolveRelativeFile(messageProperties.getFile("grinder.script", GrinderProperties.DEFAULT_SCRIPT));
                                if (messageProperties.containsKey((Object)"grinder.script") || consoleScript.canRead()) {
                                    script = new ScriptLocation(fileStoreDirectory, consoleScript);
                                }
                                this.m_agentIdentity.setNumber(startMessage.getAgentNumber());
                            } else {
                                this.m_agentIdentity.setNumber(-1);
                            }
                            if (script == null) {
                                File scriptFile = properties.resolveRelativeFile(properties.getFile("grinder.script", GrinderProperties.DEFAULT_SCRIPT));
                                script = new ScriptLocation(scriptFile);
                            }
                            this.m_logger.debug("The script location is {}", (Object)script.getFile().getAbsolutePath());
                            if (script.getFile().canRead()) continue;
                            this.m_logger.error("The script file '{}' does not exist or is not readable.", (Object)script);
                            script = null;
                            break;
                        } while (script == null);
                        if (script != null) {
                            WorkerLauncher workerLauncher;
                            DebugThreadWorkerFactory workerFactory;
                            if (!properties.containsKey((Object)"grinder.logDirectory")) {
                                properties.setFile("grinder.logDirectory", new File(this.m_agentConfig.getHome().getLogDirectory(), properties.getProperty(GRINDER_PROP_TEST_ID, "default")));
                            }
                            File logFile = new File(properties.getFile("grinder.logDirectory", new File(".")), this.m_agentIdentity.getName() + "-0.log");
                            this.m_logger.info("log file : {}", (Object)logFile);
                            AbstractLanguageHandler handler = Lang.getByFileName(script.getFile()).getHandler();
                            Properties rebasedSystemProperty = this.rebaseSystemClassPath(System.getProperties(), this.m_agentConfig.getCurrentDirectory());
                            String jvmArguments = this.buildTestRunProperties(script, handler, rebasedSystemProperty, properties);
                            if (!properties.getBoolean("grinder.debug.singleprocess", false)) {
                                WorkerProcessCommandLine workerCommandLine = new WorkerProcessCommandLine(properties, this.filterSystemClassPath(rebasedSystemProperty, handler, this.m_logger), jvmArguments, script.getDirectory());
                                this.m_logger.info("Worker process command line: {}", (Object)workerCommandLine);
                                FileUtils.writeStringToFile((File)logFile, (String)(workerCommandLine.toString() + "\n\n"));
                                workerFactory = new ProcessWorkerFactory(workerCommandLine, this.m_agentIdentity, this.m_fanOutStreamSender, consoleCommunication != null, script, properties);
                            } else {
                                this.m_logger.info("DEBUG MODE. Spawning threads rather than processes");
                                this.m_logger.warn("grinder.jvm.arguments ({}) ignored in single process mode", (Object)jvmArguments);
                                workerFactory = new DebugThreadWorkerFactory(this.m_agentIdentity, this.m_fanOutStreamSender, consoleCommunication != null, script, properties);
                            }
                            this.m_logger.debug("Worker launcher is prepared.");
                            this.m_workerLauncherForShutdown = workerLauncher = new WorkerLauncher(properties.getInt("grinder.processes", 1), (WorkerFactory)workerFactory, this.m_eventSynchronisation, this.m_logger);
                            boolean threadRampUp = properties.getBoolean("grinder.threadRampUp", false);
                            int increment = properties.getInt("grinder.processIncrement", 0);
                            if (!threadRampUp) {
                                this.m_logger.debug("'Ramp Up' mode by {}.", (Object)increment);
                            }
                            if (!threadRampUp && increment > 0) {
                                boolean moreProcessesToStart = workerLauncher.startSomeWorkers(properties.getInt("grinder.initialProcesses", increment));
                                if (moreProcessesToStart) {
                                    int incrementInterval = properties.getInt("grinder.processIncrementInterval", 60000);
                                    RampUpTimerTask rampUpTimerTask = new RampUpTimerTask(workerLauncher, increment);
                                    this.m_timer.scheduleAtFixedRate((TimerTask)rampUpTimerTask, incrementInterval, (long)incrementInterval);
                                }
                            } else {
                                this.m_logger.debug("start all workers");
                                workerLauncher.startAllWorkers();
                            }
                            Condition condition = this.m_eventSynchronisation;
                            synchronized (condition) {
                                long maximumShutdownTime = 5000L;
                                long consoleSignalTime = -1L;
                                while (!workerLauncher.allFinished()) {
                                    this.m_logger.debug("Waiting until all workers are finished");
                                    if (consoleSignalTime == -1L && this.m_consoleListener.checkForMessage(14)) {
                                        this.m_logger.info("Don't start anymore by message from controller.");
                                        workerLauncher.dontStartAnyMore();
                                        consoleSignalTime = System.currentTimeMillis();
                                    }
                                    if (consoleSignalTime >= 0L && System.currentTimeMillis() - consoleSignalTime > 5000L) {
                                        this.m_logger.info("Terminating unresponsive processes by force");
                                        workerLauncher.destroyAllWorkers();
                                    }
                                    this.m_eventSynchronisation.waitNoInterrruptException(5000L);
                                }
                                this.m_logger.info("All workers are finished");
                            }
                            this.m_logger.debug("Normal shutdown");
                            workerLauncher.shutdown();
                            break;
                        }
                        if (consoleCommunication == null) {
                            this.m_logger.debug("Console communication death");
                            break;
                        }
                        this.m_consoleListener.discardMessages(1);
                        if (!this.m_consoleListener.received(15)) {
                            this.m_logger.debug("Test is finished, wait for console signal");
                            this.m_consoleListener.waitForMessage();
                        }
                        if (this.m_consoleListener.received(1)) {
                            startMessage = this.m_consoleListener.getLastStartGrinderMessage();
                            continue;
                        }
                        if (this.m_consoleListener.received(12)) {
                            this.m_logger.debug("Got shutdown message");
                            break;
                        }
                        this.m_logger.debug("Natural death");
                        startMessage = null;
                    }
                    if (this.m_timer != null) {
                        this.m_timer.cancel();
                        this.m_timer = null;
                    }
                    this.shutdownConsoleCommunication(consoleCommunication);
                    if (this.m_fanOutStreamSender == null) break block43;
                }
                catch (Exception e) {
                    this.m_logger.error("Exception occurred in the agent message loop", (Throwable)e);
                    break block44;
                }
                finally {
                    if (this.m_timer != null) {
                        this.m_timer.cancel();
                        this.m_timer = null;
                    }
                    this.shutdownConsoleCommunication(consoleCommunication);
                    if (this.m_fanOutStreamSender != null) {
                        this.m_fanOutStreamSender.shutdown();
                        this.m_fanOutStreamSender = null;
                    }
                    this.m_consoleListener.shutdown();
                    this.m_logger.info("Test shuts down.");
                }
                this.m_fanOutStreamSender.shutdown();
                this.m_fanOutStreamSender = null;
            }
            this.m_consoleListener.shutdown();
            this.m_logger.info("Test shuts down.");
        }
    }

    private Properties rebaseSystemClassPath(Properties properties, File curDir) {
        Properties newProperties = new Properties();
        newProperties.putAll((Map<?, ?>)properties);
        StringBuilder newClassPath = new StringBuilder();
        boolean isFirst = true;
        for (String each : StringUtils.split((String)properties.getProperty("java.class.path"), (String)File.pathSeparator)) {
            File file = new File(each);
            if (!file.isAbsolute()) {
                file = new File(curDir, each);
            }
            if (!isFirst) {
                newClassPath.append(File.pathSeparator);
            }
            isFirst = false;
            newClassPath.append(FilenameUtils.normalize((String)file.getAbsolutePath()));
        }
        newProperties.put("java.class.path", newClassPath.toString());
        return newProperties;
    }

    private boolean isSecurityEnabled(GrinderProperties properties) {
        return this.m_agentConfig.isSecurityEnabled() && properties.getBoolean("grinder.security", false);
    }

    private String buildTestRunProperties(ScriptLocation script, AbstractLanguageHandler handler, Properties systemProperty, GrinderProperties properties) {
        PropertyBuilder builder = new PropertyBuilder(properties, script.getDirectory(), this.isSecurityEnabled(properties), properties.getProperty("grinder.security.level", "normal"), properties.getProperty("ngrinder.etc.hosts"), NetworkUtils.getLocalHostName(), this.m_agentConfig.getAgentProperties().getPropertyBoolean("agent.server_mode"), this.m_agentConfig.getAgentProperties().getPropertyBoolean("agent.limit_xmx"), this.m_agentConfig.getAgentProperties().getPropertyBoolean("agent.enable_local_dns"), this.m_agentConfig.getAgentProperties().getProperty("agent.java_opt"));
        String jvmArguments = builder.buildJVMArgument();
        properties.setProperty("grinder.jvm.classpath", this.buildClassPath(systemProperty, properties, handler, builder));
        this.m_logger.info("grinder properties {}", (Object)properties);
        this.m_logger.info("jvm arguments {}", (Object)jvmArguments);
        if (properties.containsKey((Object)"grinder.duration") && !properties.containsKey((Object)"grinder.runs")) {
            properties.setInt("grinder.runs", 0);
        }
        return jvmArguments;
    }

    private String buildClassPath(Properties systemProperty, GrinderProperties properties, AbstractLanguageHandler handler, PropertyBuilder builder) {
        String agentJvmClassPath;
        String rebaseCustomClassPath = this.getForeMostClassPath(systemProperty, handler, this.m_logger) + File.pathSeparator + builder.rebaseUserLibraryClassPath(properties.getProperty("grinder.jvm.user.library.classpath", ""));
        String customJvmClassPath = properties.getProperty("grinder.jvm.classpath");
        if (StringUtils.isNotBlank((String)customJvmClassPath)) {
            rebaseCustomClassPath = customJvmClassPath + File.pathSeparator + rebaseCustomClassPath;
        }
        if (StringUtils.isNotBlank((String)(agentJvmClassPath = this.m_agentConfig.getAgentProperties().getProperty("agent.jvm.classpath")))) {
            rebaseCustomClassPath = agentJvmClassPath + File.pathSeparator + rebaseCustomClassPath;
        }
        return rebaseCustomClassPath;
    }

    private String getForeMostClassPath(Properties properties, AbstractLanguageHandler handler, Logger logger) {
        String systemClassPath = properties.getProperty("java.class.path");
        AbstractGrinderClassPathProcessor classPathProcessor = handler.getClassPathProcessor();
        return classPathProcessor.filterForeMostClassPath(systemClassPath, logger) + File.pathSeparator + classPathProcessor.filterPatchClassPath(systemClassPath, logger);
    }

    private Properties filterSystemClassPath(Properties properties, AbstractLanguageHandler handler, Logger logger) {
        String property = properties.getProperty("java.class.path", "");
        logger.debug("Total system class path in total is " + property);
        String newClassPath = handler.getClassPathProcessor().filterClassPath(property, logger);
        Properties returnProperties = new Properties(properties);
        returnProperties.setProperty("java.class.path", newClassPath);
        logger.debug("Filtered system class path is {}", (Object)newClassPath);
        return returnProperties;
    }

    private GrinderProperties createAndMergeProperties(GrinderProperties properties, GrinderProperties startMessageProperties) throws GrinderProperties.PersistenceException {
        if (startMessageProperties != null) {
            properties.putAll((Map)startMessageProperties);
        }
        return properties;
    }

    private void shutdownConsoleCommunication(ConsoleCommunication consoleCommunication) {
        if (consoleCommunication != null) {
            consoleCommunication.shutdown();
        }
        this.m_consoleListener.discardMessages(15);
    }

    public void shutdown() {
        if (this.m_timer != null) {
            this.m_timer.cancel();
            this.m_timer = null;
        }
        if (this.m_fanOutStreamSender != null) {
            this.m_fanOutStreamSender.shutdown();
        }
        this.m_consoleListener.shutdown();
        if (this.m_workerLauncherForShutdown != null && !this.m_workerLauncherForShutdown.allFinished()) {
            this.m_workerLauncherForShutdown.destroyAllWorkers();
        }
        this.m_logger.info("Agent is terminated by force");
    }

    private final class ConsoleCommunication {
        private final ClientSender m_sender;
        private final Connector m_connector;
        private final TimerTask m_reportRunningTask;
        private final MessagePump m_messagePump;

        public ConsoleCommunication(Connector connector, String user) throws CommunicationException, FileStore.FileStoreException, IOException {
            ClientReceiver receiver = ClientReceiver.connect((Connector)connector, (Address)new AgentAddress((AgentIdentity)AgentImplementationEx.this.m_agentIdentity));
            this.m_sender = ClientSender.connect((ClientReceiver)receiver);
            this.m_connector = connector;
            if (AgentImplementationEx.this.m_fileStore == null) {
                File base = AgentImplementationEx.this.m_agentConfig.getHome().getDirectory();
                File directory = new File(new File(base, "file-store"), user);
                AgentImplementationEx.this.m_fileStore = new FileStore(directory, AgentImplementationEx.this.m_logger);
            }
            this.m_sender.send((Message)new AgentProcessReportMessage(1, AgentImplementationEx.this.m_fileStore.getCacheHighWaterMark()));
            File cacheDir = AgentImplementationEx.this.m_fileStore.getIncomingDirectory().getFile();
            this.m_sender.send((Message)new DistFilesDigestMessage(net.grinder.util.FileUtils.getFilesDigest(cacheDir, net.grinder.util.FileUtils.getAllFilesInDirectory(cacheDir))));
            AgentImplementationEx.this.m_logger.info("Send digest of cached files to controller.");
            MessageDispatchSender fileStoreMessageDispatcher = new MessageDispatchSender();
            AgentImplementationEx.this.m_fileStore.registerMessageHandlers((MessageDispatchRegistry)fileStoreMessageDispatcher);
            MessageDispatchSender messageDispatcher = new MessageDispatchSender();
            AgentImplementationEx.this.m_consoleListener.registerMessageHandlers((MessageDispatchRegistry)messageDispatcher);
            fileStoreMessageDispatcher.addFallback((MessageDispatchRegistry.Handler)new TeeSender((Sender)messageDispatcher, (Sender)new IgnoreShutdownSender((Sender)AgentImplementationEx.this.m_fanOutStreamSender)));
            this.m_messagePump = new MessagePump((Receiver)receiver, (Sender)fileStoreMessageDispatcher, 1);
            this.m_reportRunningTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        ConsoleCommunication.this.m_sender.send((Message)new AgentProcessReportMessage(2, AgentImplementationEx.this.m_fileStore.getCacheHighWaterMark()));
                    }
                    catch (CommunicationException e) {
                        this.cancel();
                        AgentImplementationEx.this.m_logger.error("Error while pumping up the AgentProcessReportMessage", (Object)e.getMessage());
                        AgentImplementationEx.this.m_logger.debug("The error detail is ", (Throwable)e);
                    }
                }
            };
        }

        public void start() {
            this.m_messagePump.start();
            AgentImplementationEx.this.m_timer.schedule(this.m_reportRunningTask, 900L, 900L);
        }

        public Connector getConnector() {
            return this.m_connector;
        }

        public void shutdown() {
            this.m_reportRunningTask.cancel();
            try {
                this.m_sender.send((Message)new AgentProcessReportMessage(3, AgentImplementationEx.this.m_fileStore.getCacheHighWaterMark()));
                AgentImplementationEx.this.m_logger.debug("Shut down message was sent");
            }
            catch (CommunicationException e) {
                NoOp.noOp();
            }
            finally {
                this.m_messagePump.shutdown();
            }
        }
    }

    private static class RampUpTimerTask
    extends TimerTask {
        private final WorkerLauncher m_processLauncher;
        private final int m_processIncrement;

        public RampUpTimerTask(WorkerLauncher processLauncher, int processIncrement) {
            this.m_processLauncher = processLauncher;
            this.m_processIncrement = processIncrement;
        }

        @Override
        public void run() {
            try {
                boolean moreProcessesToStart = this.m_processLauncher.startSomeWorkers(this.m_processIncrement);
                if (!moreProcessesToStart) {
                    super.cancel();
                }
            }
            catch (EngineException e) {
                System.err.println("Failed to start processes");
            }
        }
    }
}

