/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.engine.agent.Worker;
import net.grinder.engine.agent.WorkerFactory;
import net.grinder.engine.common.EngineException;
import net.grinder.util.thread.Condition;
import net.grinder.util.thread.ExecutorFactory;
import net.grinder.util.thread.InterruptibleRunnable;
import net.grinder.util.thread.InterruptibleRunnableAdapter;
import org.slf4j.Logger;

public class ErrorStreamRedirectWorkerLauncher {
    private final ExecutorService m_executor;
    private final WorkerFactory m_workerFactory;
    private final Condition m_notifyOnFinish;
    private final Logger m_logger;
    private final Worker[] m_workers;
    private int m_nextWorkerIndex = 0;
    private OutputStream errStream;

    public ErrorStreamRedirectWorkerLauncher(int numberOfWorkers, WorkerFactory workerFactory, Condition notifyOnFinish, Logger logger, OutputStream errStream) {
        this(ExecutorFactory.createThreadPool((String)"WorkerLauncher", (int)1), numberOfWorkers, workerFactory, notifyOnFinish, logger);
        this.errStream = errStream;
    }

    ErrorStreamRedirectWorkerLauncher(ExecutorService executor, int numberOfWorkers, WorkerFactory workerFactory, Condition notifyOnFinish, Logger logger) {
        this.m_executor = executor;
        this.m_workerFactory = workerFactory;
        this.m_notifyOnFinish = notifyOnFinish;
        this.m_logger = logger;
        this.m_workers = new Worker[numberOfWorkers];
    }

    public void startAllWorkers() throws EngineException {
        this.startSomeWorkers(this.m_workers.length - this.m_nextWorkerIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean startSomeWorkers(int numberOfWorkers) throws EngineException {
        int numberToStart = Math.min(numberOfWorkers, this.m_workers.length - this.m_nextWorkerIndex);
        for (int i = 0; i < numberToStart; ++i) {
            int workerIndex = this.m_nextWorkerIndex++;
            Worker worker = this.m_workerFactory.create(this.errStream, this.errStream);
            Worker[] workerArray = this.m_workers;
            // MONITORENTER : this.m_workers
            this.m_workers[workerIndex] = worker;
            // MONITOREXIT : workerArray
            try {
                this.m_executor.execute((Runnable)new InterruptibleRunnableAdapter((InterruptibleRunnable)new WaitForWorkerTask(workerIndex)));
            }
            catch (RejectedExecutionException e) {
                this.m_logger.error("Failed to wait for " + worker.getIdentity().getName(), (Throwable)e);
                worker.destroy();
                return false;
            }
            this.m_logger.info("worker " + worker.getIdentity().getName() + " started");
        }
        if (this.m_workers.length <= this.m_nextWorkerIndex) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allFinished() {
        if (this.m_nextWorkerIndex < this.m_workers.length) {
            return false;
        }
        Worker[] workerArray = this.m_workers;
        synchronized (this.m_workers) {
            for (Worker m_worker : this.m_workers) {
                if (m_worker == null) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    public void shutdown() {
        this.m_executor.shutdown();
    }

    public void dontStartAnyMore() {
        this.m_nextWorkerIndex = this.m_workers.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAllWorkers() {
        this.dontStartAnyMore();
        Worker[] workerArray = this.m_workers;
        synchronized (this.m_workers) {
            for (Worker m_worker : this.m_workers) {
                if (m_worker == null) continue;
                m_worker.destroy();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private final class WaitForWorkerTask
    implements InterruptibleRunnable {
        private final int m_workerIndex;

        public WaitForWorkerTask(int workerIndex) {
            this.m_workerIndex = workerIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interruptibleRun() {
            Worker worker;
            Condition condition = ErrorStreamRedirectWorkerLauncher.this.m_workers;
            synchronized (condition) {
                worker = ErrorStreamRedirectWorkerLauncher.this.m_workers[this.m_workerIndex];
            }
            assert (worker != null);
            try {
                worker.waitFor();
            }
            catch (UncheckedInterruptedException e) {
                worker.destroy();
            }
            condition = ErrorStreamRedirectWorkerLauncher.this.m_workers;
            synchronized (condition) {
                ((ErrorStreamRedirectWorkerLauncher)ErrorStreamRedirectWorkerLauncher.this).m_workers[this.m_workerIndex] = null;
            }
            if (ErrorStreamRedirectWorkerLauncher.this.allFinished()) {
                condition = ErrorStreamRedirectWorkerLauncher.this.m_notifyOnFinish;
                synchronized (condition) {
                    ErrorStreamRedirectWorkerLauncher.this.m_notifyOnFinish.notifyAll();
                }
            }
        }
    }
}

