/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.common;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import net.grinder.communication.ConnectionType;
import net.grinder.communication.Connector;

public class AgentControllerConnectorFactory {
    private final ConnectionType m_connectionType;

    public AgentControllerConnectorFactory(ConnectionType connectionType) {
        this.m_connectionType = connectionType;
    }

    public Connector create(String host, int port) {
        return new Connector(host, port, this.m_connectionType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connector create(int port) {
        try (ServerSocket serverSocket = new ServerSocket(port);){
            Socket socket = serverSocket.accept();
            Connector connector = new Connector(socket, this.m_connectionType);
            return connector;
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to create connector", e);
        }
    }
}

