/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.ngrinder.common.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogCompressUtils {
    private static final int COMPRESS_BUFFER_SIZE = 8096;
    public static final Logger LOGGER = LoggerFactory.getLogger(LogCompressUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(File[] logFiles, Charset fromEncoding, Charset toEncoding) {
        byte[] byArray;
        FileInputStream fis = null;
        InputStreamReader isr = null;
        ByteArrayOutputStream out = null;
        ZipOutputStream zos = null;
        OutputStreamWriter osw = null;
        if (toEncoding == null) {
            toEncoding = Charset.defaultCharset();
        }
        if (fromEncoding == null) {
            fromEncoding = Charset.defaultCharset();
        }
        try {
            out = new ByteArrayOutputStream();
            zos = new ZipOutputStream((OutputStream)out);
            osw = new OutputStreamWriter((OutputStream)zos, toEncoding);
            for (File each : logFiles) {
                try {
                    int count;
                    fis = new FileInputStream(each);
                    isr = new InputStreamReader((InputStream)fis, fromEncoding);
                    ZipEntry zipEntry = new ZipEntry(each.getName());
                    zipEntry.setTime(each.lastModified());
                    zos.putNextEntry(zipEntry);
                    char[] buffer = new char[8096];
                    while ((count = isr.read(buffer, 0, 8096)) != -1) {
                        osw.write(buffer, 0, count);
                    }
                    osw.flush();
                    zos.flush();
                    zos.closeEntry();
                }
                catch (IOException e) {
                    try {
                        LOGGER.error("Error occurs while compressing {} : {}", (Object)each.getAbsolutePath(), (Object)e.getMessage());
                        LOGGER.debug("Details ", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(isr);
                        IOUtils.closeQuietly((InputStream)fis);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)isr);
                    IOUtils.closeQuietly((InputStream)fis);
                    continue;
                }
                IOUtils.closeQuietly((Reader)isr);
                IOUtils.closeQuietly((InputStream)fis);
            }
            zos.finish();
            zos.flush();
            byArray = out.toByteArray();
        }
        catch (IOException iOException) {
            byte[] byArray2;
            try {
                LOGGER.error("Error occurs while compressing log : {} ", (Object)iOException.getMessage());
                LOGGER.debug("Details : ", (Throwable)iOException);
                byArray2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zos);
                IOUtils.closeQuietly((OutputStream)out);
                IOUtils.closeQuietly(osw);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)zos);
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly((Writer)osw);
            return byArray2;
        }
        IOUtils.closeQuietly((OutputStream)zos);
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((Writer)osw);
        return byArray;
    }

    public static byte[] compress(File[] logFiles) {
        return LogCompressUtils.compress(logFiles, Charset.defaultCharset(), Charset.defaultCharset());
    }

    public static byte[] compress(File logFile) {
        return LogCompressUtils.compress(new File[]{logFile}, Charset.defaultCharset(), Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decompress(byte[] zipEntry, File toFile) {
        FileOutputStream fos = null;
        ByteArrayInputStream bio = new ByteArrayInputStream(zipEntry);
        try {
            fos = new FileOutputStream(toFile);
            LogCompressUtils.decompress(bio, fos, Long.MAX_VALUE);
        }
        catch (IOException e) {
            try {
                LOGGER.error("Error occurs during extracting to {} : {} ", (Object)toFile.getAbsolutePath(), (Object)e.getMessage());
                LOGGER.debug("Details : ", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                IOUtils.closeQuietly((InputStream)bio);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
            IOUtils.closeQuietly((InputStream)bio);
        }
        IOUtils.closeQuietly((OutputStream)fos);
        IOUtils.closeQuietly((InputStream)bio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decompress(InputStream inputStream, OutputStream outputStream, long limit) {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(inputStream);
            byte[] buffer = new byte[8096];
            long total = 0L;
            Preconditions.checkNotNull(zipInputStream.getNextEntry(), "In zip, it should have at least one entry");
            while (true) {
                int count;
                if ((count = zipInputStream.read(buffer, 0, 8096)) != -1 && (total += (long)count) < limit) {
                    outputStream.write(buffer, 0, count);
                    continue;
                }
                if (zipInputStream.getNextEntry() == null) break;
            }
            outputStream.flush();
        }
        catch (IOException e) {
            try {
                LOGGER.error("Error occurs while decompressing {}", (Object)e.getMessage());
                LOGGER.debug("Details : ", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)zipInputStream);
        }
        IOUtils.closeQuietly((InputStream)zipInputStream);
    }
}

