/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.ngrinder.common.exception.NGrinderRuntimeException;
import org.ngrinder.common.util.ExceptionUtils;
import org.ngrinder.common.util.NoOp;
import org.python.google.common.net.InetAddresses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NetworkUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkUtils.class);
    public static String DEFAULT_LOCAL_HOST_ADDRESS = NetworkUtils.getLocalHostAddress();
    public static String DEFAULT_LOCAL_HOST_NAME = NetworkUtils.getLocalHostName();
    public static List<InetAddress> DEFAULT_LOCAL_ADDRESSES = NetworkUtils.getAllLocalNonLoopbackAddresses(false);

    public static String getLocalHostAddress() {
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (Exception e) {
            LOGGER.error("Error while get localhost address", (Throwable)e);
        }
        if (localHost != null && !localHost.isLoopbackAddress()) {
            return localHost.getHostAddress();
        }
        return NetworkUtils.getLocalHostAddress("www.google.com", 80);
    }

    static String getLocalHostAddress(String byConnecting, int port) {
        InetAddress addr = NetworkUtils.getLocalInetAddress(byConnecting, port);
        if (addr != null) {
            return addr.getHostAddress();
        }
        return "127.0.0.1";
    }

    static String getLocalHostName(String byConnecting, int port) {
        InetAddress addr = NetworkUtils.getLocalInetAddress(byConnecting, port);
        if (addr != null) {
            return addr.getHostName();
        }
        return "localhost";
    }

    static InetAddress getLocalInetAddress(String byConnecting, int port) {
        InetAddress addr = NetworkUtils.getAddressWithSocket(byConnecting, port);
        if (addr == null) {
            addr = NetworkUtils.getAddressWithSocket("www.baidu.com", 80);
        }
        if (addr == null) {
            try {
                addr = NetworkUtils.getFirstNonLoopbackAddress(true, false);
            }
            catch (SocketException e2) {
                NoOp.noOp();
            }
        }
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetAddress getAddressWithSocket(String byConnecting, int port) {
        Socket s = new Socket();
        try {
            if (NetworkUtils.tryConnection(byConnecting, port, s)) {
                InetAddress inetAddress = s.getLocalAddress();
                return inetAddress;
            }
        }
        finally {
            IOUtils.closeQuietly((Socket)s);
        }
        return null;
    }

    public static boolean tryConnection(String byConnecting, int port, Socket socket) {
        try {
            socket.connect(new InetSocketAddress(byConnecting, port), 2000);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static InetAddress getFirstNonLoopbackAddress(boolean preferIpv4, boolean preferIPv6) throws SocketException {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            if (!i.isUp()) continue;
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress()) continue;
                if (addr instanceof Inet4Address) {
                    if (preferIPv6) continue;
                    return addr;
                }
                if (!(addr instanceof Inet6Address) || preferIpv4) continue;
                return addr;
            }
        }
        return null;
    }

    public static String getLocalHostName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            LOGGER.error("Error while get localhost name", (Throwable)e);
        }
        if (hostName != null && !"localhost".equals(hostName)) {
            return hostName;
        }
        return NetworkUtils.getLocalHostName("www.google.com", 80);
    }

    public static InetAddress[] getIpsFromHost(String host) {
        try {
            return InetAddress.getAllByName(host);
        }
        catch (UnknownHostException e) {
            LOGGER.error("Error while get localhost name for {}", (Object)host, (Object)e);
            return new InetAddress[0];
        }
    }

    public static List<Integer> getAvailablePorts(String ip, int size, int from, int limit) {
        ArrayList<Integer> ports = new ArrayList<Integer>(size);
        InetAddress inetAddress = null;
        if (StringUtils.isNotBlank((String)ip)) {
            try {
                inetAddress = InetAddress.getByName(ip);
            }
            catch (Exception e) {
                NoOp.noOp();
            }
        }
        for (int i = 0; i < size; ++i) {
            int freePort = NetworkUtils.checkPortAvailability(inetAddress, from, limit);
            ports.add(freePort);
            from = freePort + 1;
        }
        return ports;
    }

    public static int checkPortAvailability(InetAddress inetAddress, int scanStartPort, int limit) {
        do {
            if (!NetworkUtils.checkExactPortAvailability(inetAddress, scanStartPort)) continue;
            return scanStartPort;
        } while (scanStartPort++ <= limit);
        throw ExceptionUtils.processException("no port is available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkExactPortAvailability(InetAddress inetAddress, int port) {
        ServerSocket socket = null;
        try {
            socket = inetAddress == null ? new ServerSocket(port) : new ServerSocket(port, 1, inetAddress);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    NoOp.noOp();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getFreePort() {
        int n;
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            n = socket.getLocalPort();
        }
        catch (IOException e) {
            try {
                NoOp.noOp();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(socket);
                throw throwable;
            }
            IOUtils.closeQuietly((ServerSocket)socket);
            return -1;
        }
        IOUtils.closeQuietly((ServerSocket)socket);
        return n;
    }

    public static boolean isIP6Supported() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isPointToPoint()) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!(inetAddress instanceof Inet6Address)) continue;
                    return true;
                }
            }
        }
        catch (SocketException e) {
            LOGGER.error("Error while resolving non look back local addresses.", (Throwable)e);
        }
        return false;
    }

    public static String getAllPBindingAddress() {
        return NetworkUtils.isIP6Supported() ? "[::]" : "0.0.0.0";
    }

    public static IPPortPair convertIPAndPortPair(String ipPortString, int defaultPort) {
        if (InetAddresses.isInetAddress((String)(ipPortString = NetworkUtils.removeScopedMarkerFromIP(ipPortString)))) {
            return new IPPortPair(ipPortString, defaultPort);
        }
        int i = ipPortString.lastIndexOf(":");
        String ipPart = ipPortString;
        int portPart = defaultPort;
        if (i != -1) {
            portPart = NumberUtils.toInt((String)ipPortString.substring(i + 1));
            ipPart = ipPortString.substring(0, i);
        }
        return new IPPortPair(NetworkUtils.getIP(ipPart), portPart);
    }

    public static String removeScopedMarkerFromIP(String ip) {
        if (StringUtils.isNotEmpty((String)ip) && ip.contains("%")) {
            ip = ip.substring(0, ip.lastIndexOf("%"));
        }
        return ip;
    }

    public static String getIP(String ipOrHost) {
        String ip = ipOrHost;
        if (InetAddresses.isInetAddress((String)ip)) {
            return ip;
        }
        try {
            ip = InetAddress.getByName(ipOrHost).getHostAddress();
        }
        catch (UnknownHostException e) {
            ip = "127.0.0.1";
            LOGGER.error("Error while resolving {} to IP. Use {} instead.", (Object)ipOrHost, (Object)ip);
            LOGGER.debug("Details : ", (Throwable)e);
        }
        return ip;
    }

    private static List<InetAddress> getAllLocalNonLoopbackAddresses(boolean onlyIPv4) {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (!networkInterface.isUp()) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (onlyIPv4 && inetAddress instanceof Inet6Address || inetAddress.isLoopbackAddress()) continue;
                    addresses.add(inetAddress);
                }
            }
        }
        catch (SocketException e) {
            LOGGER.error("Error while resolving non look back local addresses.", (Throwable)e);
        }
        return addresses;
    }

    public static String selectLocalIp(List<String> ips) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    String hostAddress = addr.getHostAddress();
                    if (!ips.contains(hostAddress)) continue;
                    return hostAddress;
                }
            }
        }
        catch (SocketException e) {
            throw new NGrinderRuntimeException("error while resolving current ip", e);
        }
        throw new NGrinderRuntimeException("the ip address set doesn't contain current ips");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getDnsServers() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        ArrayList<String> dnsServers = new ArrayList<String>();
        try (InitialDirContext ctx = null;){
            ctx = new InitialDirContext(env);
            String dnsString = (String)ctx.getEnvironment().get("java.naming.provider.url");
            for (String each : dnsString.split(" ")) {
                dnsServers.add(each.replace("dns://", ""));
            }
        }
        return dnsServers;
    }

    public static class IPPortPair {
        private InetAddress ip;
        private final int port;

        public IPPortPair(String ip, int port) {
            try {
                this.ip = InetAddress.getByName(ip);
            }
            catch (UnknownHostException e) {
                LOGGER.error("{} is not accessible ip", (Object)ip);
            }
            this.port = port;
        }

        public boolean isValid() {
            return this.ip != null;
        }

        public int getPort() {
            return this.port;
        }

        public String getIP() {
            return this.ip.getHostAddress();
        }

        public String getFormattedIP() {
            if (this.isIP6()) {
                return "[" + this.ip.getHostAddress() + "]";
            }
            return this.ip.getHostAddress();
        }

        public String toString() {
            return this.getFormattedIP() + ":" + this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IPPortPair that = (IPPortPair)o;
            return this.port == that.port && !(this.ip == null ? that.ip != null : !this.ip.equals(that.ip));
        }

        public int hashCode() {
            int result = this.ip != null ? this.ip.hashCode() : 0;
            result = 31 * result + this.port;
            return result;
        }

        public boolean isLocalHost() {
            if (this.ip == null) {
                return false;
            }
            if (this.ip.isAnyLocalAddress() || this.ip.isLoopbackAddress() || this.ip.isLinkLocalAddress()) {
                return true;
            }
            try {
                return NetworkInterface.getByInetAddress(this.ip) != null;
            }
            catch (SocketException e) {
                return false;
            }
        }

        public boolean isIP6() {
            return this.ip instanceof Inet6Address;
        }
    }
}

