/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.ngrinder.common.util.NoOp;
import org.ngrinder.common.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final Map<Class, List<Field>> fieldCache = new ConcurrentHashMap<Class, List<Field>>();

    public static Object getFieldValue(Object object, String fieldName) {
        Field field = ReflectionUtils.getDeclaredField(object, fieldName);
        Preconditions.checkNotNull(field, "Could not find field [%s] on target [%s]", fieldName, object);
        ReflectionUtils.makeAccessible(field);
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static Field getDeclaredField(Object object, String fieldName) {
        Preconditions.checkNotNull(object);
        Preconditions.checkArgument(StringUtils.isNotBlank((String)fieldName));
        for (Class<?> superClass = object.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                NoOp.noOp();
                continue;
            }
        }
        return null;
    }

    private static void makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
    }

    public static List<Field> getDeclaredFieldsIncludingParent(Class<?> current) {
        if (fieldCache.containsKey(current)) {
            return fieldCache.get(current);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        fieldCache.put(current, fields);
        while (current != null) {
            List<Field> declared = Arrays.asList(current.getDeclaredFields());
            fields.addAll(declared);
            current = current.getSuperclass();
        }
        return fields;
    }
}

