/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.infra;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.ngrinder.common.util.ExceptionUtils;
import org.ngrinder.common.util.NoOp;
import org.ngrinder.common.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentHome {
    private final File directory;
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentHome.class);

    public AgentHome(File directory) {
        Preconditions.checkNotNull(directory, "The directory should not be null.");
        if (StringUtils.contains((String)directory.getAbsolutePath().trim(), (String)" ")) {
            throw ExceptionUtils.processException(String.format("nGrinder agent home directory \"%s\" should not contain space.Please set NGRINDER_AGENT_HOME env var in the different location", directory.getAbsolutePath()));
        }
        if (!directory.exists() && !directory.mkdirs()) {
            throw ExceptionUtils.processException(String.format("nGrinder agent home directory %s is not created. Please check the permission", directory.getAbsolutePath()));
        }
        if (!directory.isDirectory()) {
            throw ExceptionUtils.processException(String.format("nGrinder home directory %s is not directory. Please delete this sourceFile in advance", directory.getAbsolutePath()));
        }
        if (!directory.canWrite()) {
            throw ExceptionUtils.processException(String.format("nGrinder home directory %s is not writable. Please adjust permission on this folder", directory));
        }
        this.directory = directory;
    }

    public File getDirectory() {
        return this.directory;
    }

    public File getNativeDirectory() {
        return this.mkDir(this.getFile("native"));
    }

    public File mkDir(File file) {
        if (!file.exists() && file.mkdirs()) {
            LOGGER.info("{} is created.", (Object)file.getPath());
        }
        return file;
    }

    public File getTempDirectory() {
        return this.mkDir(this.getFile("temp"));
    }

    public void copyFileTo(File sourceFile, String target) {
        File targetFile = new File(this.directory, target);
        try {
            FileUtils.copyFile((File)sourceFile, (File)targetFile);
        }
        catch (IOException e) {
            throw ExceptionUtils.processException("Failed to write a sourceFile to " + target, e);
        }
    }

    public void writeFileTo(String content, String target) {
        File targetFile = new File(this.directory, target);
        try {
            FileUtils.write((File)targetFile, (CharSequence)content);
        }
        catch (IOException e) {
            throw ExceptionUtils.processException("Failed to write a sourceFile to " + target, e);
        }
    }

    public Properties getProperties(String path) {
        Properties properties = new Properties();
        try {
            File propertiesFile = new File(this.directory, path);
            String config = FileUtils.readFileToString((File)propertiesFile, (String)"UTF-8");
            properties.load(new StringReader(config));
        }
        catch (IOException e) {
            NoOp.noOp();
        }
        return properties;
    }

    public File getFile(String path) {
        return new File(this.getDirectory(), path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties(String path, Properties properties) {
        FileOutputStream out = null;
        try {
            File propertiesFile = new File(this.getDirectory(), path);
            out = FileUtils.openOutputStream((File)propertiesFile);
            properties.store(out, null);
        }
        catch (IOException e) {
            try {
                LOGGER.error("Could not save property  sourceFile on " + path, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public File getLogDirectory() {
        return new File(this.getDirectory(), "log");
    }
}

