/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import net.grinder.common.processidentity.AgentIdentity;
import net.grinder.engine.controller.AgentControllerIdentityImplementation;
import net.grinder.message.console.AgentControllerState;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Type;
import org.ngrinder.common.util.AccessUtils;
import org.ngrinder.model.BaseEntity;

@Entity
@Table(name="AGENT")
public class AgentInfo
extends BaseEntity<AgentInfo> {
    private static final long serialVersionUID = 677610999461391813L;
    private String ip;
    @Transient
    private Integer port;
    @Transient
    private AgentIdentity agentIdentity;
    @Column(name="hostName")
    private String name;
    @Transient
    private AgentControllerState state;
    @Transient
    private String region;
    @Type(type="true_false")
    @Column(columnDefinition="char(1) default 'F'")
    private Boolean approved;
    @Transient
    private String version;

    @PrePersist
    public void init() {
        this.approved = AccessUtils.getSafe(this.approved, false);
        this.version = AccessUtils.getSafe(this.version, "");
        this.region = AccessUtils.getSafe(this.region, "");
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgentInfo other = (AgentInfo)obj;
        return StringUtils.equals((String)this.ip, (String)other.ip) && StringUtils.equals((String)this.name, (String)other.name);
    }

    @Deprecated
    public String getHostName() {
        return this.getName();
    }

    @Deprecated
    public void setHostName(String name) {
        this.setName(name);
    }

    public boolean isApproved() {
        return this.approved != null && this.approved != false;
    }

    public String getSubregion() {
        if (this.agentIdentity instanceof AgentControllerIdentityImplementation) {
            return StringUtils.defaultIfEmpty((String)((AgentControllerIdentityImplementation)this.agentIdentity).getSubregion(), (String)"");
        }
        return "";
    }

    public void setSubregion(String subregion) {
        if (this.agentIdentity instanceof AgentControllerIdentityImplementation) {
            ((AgentControllerIdentityImplementation)this.agentIdentity).setSubregion(subregion);
        }
    }

    public String getOwner() {
        if (this.agentIdentity instanceof AgentControllerIdentityImplementation) {
            return StringUtils.defaultIfEmpty((String)((AgentControllerIdentityImplementation)this.agentIdentity).getOwner(), (String)"");
        }
        return "";
    }

    @JsonIgnore
    public String getAgentKey() {
        return this.ip + "_" + this.name;
    }

    public String getIp() {
        return this.ip;
    }

    public Integer getPort() {
        return this.port;
    }

    public AgentIdentity getAgentIdentity() {
        return this.agentIdentity;
    }

    public String getName() {
        return this.name;
    }

    public AgentControllerState getState() {
        return this.state;
    }

    public String getRegion() {
        return this.region;
    }

    public Boolean getApproved() {
        return this.approved;
    }

    public String getVersion() {
        return this.version;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setAgentIdentity(AgentIdentity agentIdentity) {
        this.agentIdentity = agentIdentity;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setState(AgentControllerState state) {
        this.state = state;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setApproved(Boolean approved) {
        this.approved = approved;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return "AgentInfo(ip=" + this.getIp() + ", port=" + this.getPort() + ", agentIdentity=" + this.getAgentIdentity() + ", name=" + this.getName() + ", state=" + (Object)((Object)this.getState()) + ", region=" + this.getRegion() + ", approved=" + this.getApproved() + ", version=" + this.getVersion() + ")";
    }
}

