/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.monitor.agent;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ngrinder.monitor.mxbean.core.MXBean;

public final class MXBeanStorage {
    private static final MXBeanStorage INSTANCE = new MXBeanStorage();
    private final Map<String, MXBean> cachedMxBeans = new ConcurrentHashMap<String, MXBean>();

    private MXBeanStorage() {
    }

    public int getSize() {
        return this.cachedMxBeans.size();
    }

    public static MXBeanStorage getInstance() {
        return INSTANCE;
    }

    public MXBean getMXBean(String key) {
        return this.cachedMxBeans.get(key);
    }

    public void addMXBean(String key, MXBean mxBean) {
        this.cachedMxBeans.put(key, mxBean);
    }

    public Collection<MXBean> getMXBeans() {
        return this.cachedMxBeans.values();
    }
}

