/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.grinder.communication.Acceptor;
import net.grinder.communication.Address;
import net.grinder.communication.ConnectionType;
import net.grinder.communication.ResourcePool;
import net.grinder.communication.SocketWrapper;
import org.ngrinder.common.util.ReflectionUtils;

public class AcceptorResolver {
    public final Map<Address, ResourcePool.Resource> sockets = new ConcurrentHashMap<Address, ResourcePool.Resource>();

    public void addSocketListener(Acceptor acceptor) throws Acceptor.ShutdownException {
        ResourcePool socketSet = acceptor.getSocketSet(ConnectionType.AGENT);
        socketSet.addListener(new ResourcePool.Listener(){

            public void resourceAdded(ResourcePool.Resource resource) {
                AcceptorResolver.this.sockets.put(((SocketWrapper)resource).getAddress(), resource);
            }

            public void resourceClosed(ResourcePool.Resource resource) {
                AcceptorResolver.this.sockets.remove(((SocketWrapper)resource).getAddress());
            }
        });
    }

    public String getServerAddress(Address address) {
        ResourcePool.Resource value = this.sockets.get(address);
        if (!(value instanceof SocketWrapper)) {
            return "";
        }
        Socket socket = (Socket)ReflectionUtils.getFieldValue(value, "m_socket");
        if (socket == null) {
            return "";
        }
        return socket.getLocalAddress().getHostAddress();
    }
}

