/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import net.grinder.common.GrinderException;
import net.grinder.common.Test;
import net.grinder.console.common.ErrorHandler;
import net.grinder.console.common.Resources;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.console.model.ModelTestIndex;
import net.grinder.console.model.SampleAccumulator;
import net.grinder.console.model.SampleAccumulatorEx;
import net.grinder.console.model.SampleListener;
import net.grinder.console.model.SampleModel;
import net.grinder.statistics.PeakStatisticExpression;
import net.grinder.statistics.StatisticExpression;
import net.grinder.statistics.StatisticExpressionFactory;
import net.grinder.statistics.StatisticsIndexMap;
import net.grinder.statistics.StatisticsServices;
import net.grinder.statistics.StatisticsSet;
import net.grinder.statistics.TestStatisticsMap;
import net.grinder.util.ListenerSupport;

public class SampleModelImplementationEx
implements SampleModel {
    private final ConsoleProperties m_properties;
    private final StatisticsServices m_statisticsServices;
    private final Timer m_timer;
    private final ErrorHandler m_errorHandler;
    private final String m_stateIgnoringString;
    private final String m_stateWaitingString;
    private final String m_stateStoppedString;
    private final String m_stateCapturingString;
    private final String m_unknownTestString;
    private final Set<Test> m_tests = new TreeSet<Test>();
    private final ListenerSupport<SampleModel.Listener> m_listeners = new ListenerSupport();
    private final StatisticsIndexMap.LongIndex m_periodIndex;
    private final StatisticExpression m_tpsExpression;
    private final PeakStatisticExpression m_peakTPSExpression;
    private final SampleAccumulatorEx m_totalSampleAccumulator;
    private ModelTestIndex modelTestIndex;
    private final Map<Test, SampleAccumulator> m_accumulators = Collections.synchronizedMap(new HashMap());
    private InternalState m_state;

    public SampleModelImplementationEx(ConsoleProperties properties, StatisticsServices statisticsServices, Timer timer, Resources resources, ErrorHandler errorHandler) throws GrinderException {
        this.m_properties = properties;
        this.m_statisticsServices = statisticsServices;
        this.m_timer = timer;
        this.m_errorHandler = errorHandler;
        this.m_stateIgnoringString = resources.getString("state.ignoring.label") + " ";
        this.m_stateWaitingString = resources.getString("state.waiting.label");
        this.m_stateStoppedString = resources.getString("state.stopped.label");
        this.m_stateCapturingString = resources.getString("state.capturing.label") + " ";
        this.m_unknownTestString = resources.getString("ignoringUnknownTest.text");
        StatisticsIndexMap indexMap = statisticsServices.getStatisticsIndexMap();
        this.m_periodIndex = indexMap.getLongIndex("period");
        StatisticExpressionFactory statisticExpressionFactory = this.m_statisticsServices.getStatisticExpressionFactory();
        this.m_tpsExpression = statisticsServices.getTPSExpression();
        this.m_peakTPSExpression = statisticExpressionFactory.createPeak(indexMap.getDoubleIndex("peakTPS"), this.m_tpsExpression);
        this.m_totalSampleAccumulator = new SampleAccumulatorEx(this.m_peakTPSExpression, this.m_periodIndex, this.m_statisticsServices.getStatisticsSetFactory());
        this.setInternalState(new WaitingForTriggerState());
    }

    public StatisticExpression getTPSExpression() {
        return this.m_tpsExpression;
    }

    public StatisticExpression getPeakTPSExpression() {
        return this.m_peakTPSExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTests(Collection<Test> tests) {
        ModelTestIndex modelTestIndex;
        Test[] testArray;
        final HashSet<Test> newTests = new HashSet<Test>(tests);
        Set<Test> set = this.m_tests;
        synchronized (set) {
            newTests.removeAll(this.m_tests);
            if (newTests.size() == 0) {
                return;
            }
            this.m_tests.addAll(newTests);
            testArray = this.m_tests.toArray(new Test[this.m_tests.size()]);
        }
        SampleAccumulator[] accumulatorArray = new SampleAccumulator[testArray.length];
        Map<Test, SampleAccumulator> map = this.m_accumulators;
        synchronized (map) {
            for (Test test : newTests) {
                this.m_accumulators.put(test, new SampleAccumulator(this.m_peakTPSExpression, this.m_periodIndex, this.m_statisticsServices.getStatisticsSetFactory()));
            }
            for (int i = 0; i < accumulatorArray.length; ++i) {
                accumulatorArray[i] = this.m_accumulators.get(testArray[i]);
            }
        }
        this.modelTestIndex = modelTestIndex = new ModelTestIndex(testArray, accumulatorArray);
        this.m_listeners.apply((ListenerSupport.Informer)new ListenerSupport.Informer<SampleModel.Listener>(){

            public void inform(SampleModel.Listener l) {
                l.newTests(newTests, modelTestIndex);
            }
        });
    }

    public StatisticsSet getTotalCumulativeStatistics() {
        return this.m_totalSampleAccumulator.getCumulativeStatistics();
    }

    public void addModelListener(SampleModel.Listener listener) {
        this.m_listeners.add((Object)listener);
    }

    public void addSampleListener(Test test, SampleListener listener) {
        SampleAccumulator sampleAccumulator = this.m_accumulators.get(test);
        if (sampleAccumulator != null) {
            sampleAccumulator.addSampleListener(listener);
        }
    }

    public void addTotalSampleListener(SampleListener listener) {
        this.m_totalSampleAccumulator.addSampleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Set<Test> set = this.m_tests;
        synchronized (set) {
            this.m_tests.clear();
        }
        this.m_accumulators.clear();
        this.m_totalSampleAccumulator.zero();
        this.m_listeners.apply((ListenerSupport.Informer)new ListenerSupport.Informer<SampleModel.Listener>(){

            public void inform(SampleModel.Listener l) {
                l.resetTests();
            }
        });
    }

    public void start() {
        this.getInternalState().start();
    }

    public void stop() {
        this.getInternalState().stop();
    }

    public void addTestReport(TestStatisticsMap testStatisticsMap) {
        this.getInternalState().newTestReport(testStatisticsMap);
    }

    public SampleModel.State getState() {
        return this.getInternalState().toExternalState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zero() {
        Map<Test, SampleAccumulator> map = this.m_accumulators;
        synchronized (map) {
            for (SampleAccumulator sampleAccumulator : this.m_accumulators.values()) {
                sampleAccumulator.zero();
            }
        }
        this.m_totalSampleAccumulator.zero();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalState getInternalState() {
        SampleModelImplementationEx sampleModelImplementationEx = this;
        synchronized (sampleModelImplementationEx) {
            return this.m_state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInternalState(InternalState newState) {
        SampleModelImplementationEx sampleModelImplementationEx = this;
        synchronized (sampleModelImplementationEx) {
            this.m_state = newState;
        }
        this.m_listeners.apply((ListenerSupport.Informer)new ListenerSupport.Informer<SampleModel.Listener>(){

            public void inform(SampleModel.Listener l) {
                l.stateChanged();
            }
        });
    }

    public ModelTestIndex getModelTestIndex() {
        return this.modelTestIndex;
    }

    public StatisticsIndexMap.LongIndex getPeriodIndex() {
        return this.m_periodIndex;
    }

    public int getSampleInterval() {
        return this.m_properties.getSampleInterval();
    }

    private final class CapturingState
    extends AbstractSamplingState {
        public CapturingState() {
            SampleModelImplementationEx.this.zero();
            this.schedule();
        }

        @Override
        protected boolean shouldAccumulateSamples() {
            return true;
        }

        @Override
        protected InternalState nextState() {
            int collectSampleCount = SampleModelImplementationEx.this.m_properties.getCollectSampleCount();
            if (collectSampleCount != 0 && this.getSampleCount() > (long)collectSampleCount) {
                return new StoppedState();
            }
            return this;
        }

        public String getDescription() {
            return SampleModelImplementationEx.this.m_stateCapturingString + this.getSampleCount();
        }

        public boolean isCapturing() {
            return true;
        }

        public boolean isStopped() {
            return false;
        }
    }

    private final class TriggeredState
    extends AbstractSamplingState {
        public TriggeredState() {
            this.schedule();
        }

        @Override
        protected boolean shouldAccumulateSamples() {
            return false;
        }

        @Override
        protected InternalState nextState() {
            if (this.getSampleCount() > (long)SampleModelImplementationEx.this.m_properties.getIgnoreSampleCount()) {
                return new CapturingState();
            }
            return this;
        }

        public String getDescription() {
            return SampleModelImplementationEx.this.m_stateIgnoringString + this.getSampleCount();
        }

        public boolean isCapturing() {
            return false;
        }

        public boolean isStopped() {
            return false;
        }
    }

    private abstract class AbstractSamplingState
    extends AbstractInternalState {
        private long mlastTime;
        private volatile long msampleCount;

        private AbstractSamplingState() {
            this.mlastTime = 0L;
            this.msampleCount = 1L;
        }

        @Override
        public void newTestReport(TestStatisticsMap testStatisticsMap) {
            new TestStatisticsMap.ForEach(testStatisticsMap){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void next(Test test, StatisticsSet statistics) {
                    SampleAccumulator sampleAccumulator = SampleModelImplementationEx.this.m_accumulators.get(test);
                    Map<Test, SampleAccumulator> map = SampleModelImplementationEx.this.m_accumulators;
                    synchronized (map) {
                        if (sampleAccumulator == null) {
                            SampleModelImplementationEx.this.m_errorHandler.handleInformationMessage(SampleModelImplementationEx.this.m_unknownTestString + " " + test);
                        } else {
                            sampleAccumulator.addIntervalStatistics(statistics);
                            if (AbstractSamplingState.this.shouldAccumulateSamples()) {
                                sampleAccumulator.addCumulativeStaticstics(statistics);
                            }
                            if (!statistics.isComposite()) {
                                SampleModelImplementationEx.this.m_totalSampleAccumulator.addIntervalStatistics(statistics);
                                if (AbstractSamplingState.this.shouldAccumulateSamples()) {
                                    SampleModelImplementationEx.this.m_totalSampleAccumulator.addCumulativeStatistics(statistics);
                                }
                            }
                        }
                    }
                }
            }.iterate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void schedule() {
            AbstractSamplingState abstractSamplingState = this;
            synchronized (abstractSamplingState) {
                if (this.mlastTime == 0L) {
                    this.mlastTime = System.currentTimeMillis();
                }
            }
            SampleModelImplementationEx.this.m_timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    AbstractSamplingState.this.sample();
                }
            }, SampleModelImplementationEx.this.m_properties.getSampleInterval());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void sample() {
            Object object;
            if (!this.isActiveState()) {
                return;
            }
            try {
                SampleAccumulatorEx totalSampleAccumulatorSnapshot;
                long period;
                AbstractSamplingState abstractSamplingState = this;
                synchronized (abstractSamplingState) {
                    period = System.currentTimeMillis() - this.mlastTime;
                }
                long sampleInterval = SampleModelImplementationEx.this.m_properties.getSampleInterval();
                object = SampleModelImplementationEx.this.m_accumulators;
                synchronized (object) {
                    for (SampleAccumulator sampleAccumulator : SampleModelImplementationEx.this.m_accumulators.values()) {
                        sampleAccumulator.fireSample(sampleInterval, period);
                    }
                    totalSampleAccumulatorSnapshot = new SampleAccumulatorEx(SampleModelImplementationEx.this.m_totalSampleAccumulator);
                    SampleModelImplementationEx.this.m_totalSampleAccumulator.refreshIntervalStatistics(sampleInterval, period);
                }
                totalSampleAccumulatorSnapshot.fireSample(sampleInterval, period);
                ++this.msampleCount;
                if (SampleModelImplementationEx.this.getInternalState() instanceof StoppedState) {
                    return;
                }
                SampleModelImplementationEx.this.setInternalState(this.nextState());
                SampleModelImplementationEx.this.m_listeners.apply((ListenerSupport.Informer)new ListenerSupport.Informer<SampleModel.Listener>(){

                    public void inform(SampleModel.Listener l) {
                        l.newSample();
                    }
                });
            }
            finally {
                object = this;
                synchronized (object) {
                    if (this.isActiveState()) {
                        this.schedule();
                    }
                }
            }
        }

        public final long getSampleCount() {
            return this.msampleCount;
        }

        protected abstract boolean shouldAccumulateSamples();

        protected abstract InternalState nextState();
    }

    private final class StoppedState
    extends AbstractInternalState {
        private StoppedState() {
        }

        @Override
        public void newTestReport(TestStatisticsMap testStatisticsMap) {
        }

        public String getDescription() {
            return SampleModelImplementationEx.this.m_stateStoppedString;
        }

        public boolean isStopped() {
            return true;
        }

        public boolean isCapturing() {
            return false;
        }
    }

    private final class WaitingForTriggerState
    extends AbstractInternalState {
        public WaitingForTriggerState() {
            SampleModelImplementationEx.this.zero();
        }

        @Override
        public void newTestReport(TestStatisticsMap testStatisticsMap) {
            if (SampleModelImplementationEx.this.m_properties.getIgnoreSampleCount() == 0) {
                SampleModelImplementationEx.this.setInternalState(new CapturingState());
            } else {
                SampleModelImplementationEx.this.setInternalState(new TriggeredState());
            }
            SampleModelImplementationEx.this.getInternalState().newTestReport(testStatisticsMap);
        }

        public String getDescription() {
            return SampleModelImplementationEx.this.m_stateWaitingString;
        }

        public boolean isCapturing() {
            return false;
        }

        public boolean isStopped() {
            return false;
        }
    }

    private abstract class AbstractInternalState
    implements InternalState,
    SampleModel.State {
        private AbstractInternalState() {
        }

        protected final boolean isActiveState() {
            return SampleModelImplementationEx.this.getInternalState() == this;
        }

        @Override
        public SampleModel.State toExternalState() {
            return this;
        }

        @Override
        public void start() {
            SampleModelImplementationEx.this.setInternalState(new WaitingForTriggerState());
        }

        @Override
        public void stop() {
            SampleModelImplementationEx.this.setInternalState(new StoppedState());
        }
    }

    private static interface InternalState {
        public SampleModel.State toExternalState();

        public void start();

        public void stop();

        public void newTestReport(TestStatisticsMap var1);
    }
}

