/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class ConnectionAgentCommunicationProxy
extends Thread {
    public static final ConnectionAgentCommunicationProxy EMPTY = ConnectionAgentCommunicationProxy.empty();
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final int localPort;
    private final int remotePort;
    private final Logger LOGGER;
    private final CommunicationMessageSender sender;
    private ServerSocket localServerSocket;
    private ServerSocket remoteServerSocket;

    public ConnectionAgentCommunicationProxy(int localPort, int remotePort, Logger LOGGER, CommunicationMessageSender sender) {
        this.localPort = localPort;
        this.remotePort = remotePort;
        this.LOGGER = LOGGER;
        this.sender = sender;
    }

    @Override
    public void run() {
        try {
            this.localServerSocket = new ServerSocket(this.localPort);
            this.remoteServerSocket = new ServerSocket(this.remotePort);
            while (!this.localServerSocket.isClosed() && !this.remoteServerSocket.isClosed()) {
                Socket localSocket = this.localServerSocket.accept();
                this.sender.send();
                Socket remoteSocket = this.remoteServerSocket.accept();
                new SocketPipeline(localSocket, remoteSocket).start();
            }
        }
        catch (BindException e) {
            this.LOGGER.error("Cannot transfer agent connection", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (SocketException e) {
            this.LOGGER.debug("Communication proxy shutdown", (Throwable)e);
        }
        catch (Exception e) {
            this.LOGGER.error("Cannot transfer agent connection", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.shutdown();
        }
        this.LOGGER.info("Communication proxy shutdown");
    }

    public void shutdown() {
        IOUtils.closeQuietly((ServerSocket)this.localServerSocket);
        IOUtils.closeQuietly((ServerSocket)this.remoteServerSocket);
    }

    public static ConnectionAgentCommunicationProxy empty() {
        return new ConnectionAgentCommunicationProxy(0, 0, null, () -> {}){

            @Override
            public void shutdown() {
            }

            @Override
            public void run() {
            }
        };
    }

    private static class SocketPipeline
    extends Thread {
        private final Socket one;
        private final Socket other;

        public SocketPipeline(Socket one, Socket other) {
            this.one = one;
            this.other = other;
        }

        @Override
        public void run() {
            try {
                Thread t1 = this.transfer(this.one.getInputStream(), this.other.getOutputStream());
                Thread t2 = this.transfer(this.other.getInputStream(), this.one.getOutputStream());
                t1.join();
                t2.join();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Thread transfer(InputStream in, OutputStream out) {
            Thread thread = new Thread(() -> {
                try {
                    byte[] buffer = new byte[8192];
                    int len = in.read(buffer);
                    while (len > -1 && !this.isClosed()) {
                        out.write(buffer, 0, len);
                        len = in.read(buffer);
                    }
                }
                catch (SocketException buffer) {
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            thread.start();
            return thread;
        }

        private boolean isClosed() {
            return this.one.isClosed() || this.other.isClosed();
        }
    }

    public static interface CommunicationMessageSender {
        public void send();
    }
}

