/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import net.grinder.common.GrinderProperties;
import net.grinder.communication.FanOutStreamSender;
import net.grinder.engine.agent.AgentIdentityImplementation;
import net.grinder.engine.agent.ErrorStreamRedirectWorkerLauncher;
import net.grinder.engine.agent.ProcessWorkerFactory;
import net.grinder.engine.agent.ValidationPropertyBuilder;
import net.grinder.engine.agent.WorkerFactory;
import net.grinder.engine.agent.WorkerProcessCommandLine;
import net.grinder.engine.common.ScriptLocation;
import net.grinder.lang.AbstractLanguageHandler;
import net.grinder.lang.Lang;
import net.grinder.util.AbstractGrinderClassPathProcessor;
import net.grinder.util.Directory;
import net.grinder.util.NetworkUtils;
import net.grinder.util.thread.Condition;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.ngrinder.common.util.EncodingUtils;
import org.ngrinder.common.util.NoOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalScriptTestDriveService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalScriptTestDriveService.class);
    private static final int DEFAULT_TIMEOUT = 100;
    private final File requiredLibraryDirectory;

    public LocalScriptTestDriveService(File requiredLibraryDirectory) {
        this.requiredLibraryDirectory = requiredLibraryDirectory;
    }

    public File doValidate(File base, File script, Condition eventSynchronisation, boolean securityEnabled, String securityLevel, String hostString) {
        return this.doValidate(base, script, eventSynchronisation, securityEnabled, securityLevel, hostString, this.getDefaultTimeout());
    }

    protected int getDefaultTimeout() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File doValidate(File base, File script, Condition eventSynchronisation, boolean securityEnabled, String securityLevel, String hostString, int timeout) {
        FanOutStreamSender fanOutStreamSender = null;
        ErrorStreamRedirectWorkerLauncher workerLauncher = null;
        boolean stopByTooMuchExecution = false;
        ByteArrayOutputStream byteArrayErrorStream = new ByteArrayOutputStream();
        File file = new File(base, "validation-0.log");
        try {
            fanOutStreamSender = new FanOutStreamSender(1);
            this.deleteLogs(base);
            AbstractLanguageHandler handler = Lang.getByFileName(script).getHandler();
            AbstractGrinderClassPathProcessor classPathProcessor = handler.getClassPathProcessor();
            GrinderProperties properties = new GrinderProperties();
            ValidationPropertyBuilder builder = new ValidationPropertyBuilder(properties, new Directory(base), securityEnabled, securityLevel, hostString, NetworkUtils.getLocalHostName());
            properties.setInt("grinder.agents", 1);
            properties.setInt("grinder.processes", 1);
            properties.setInt("grinder.threads", 1);
            properties.setBoolean("grinder.script.validation", true);
            Object grinderJVMClassPath = this.getHomeLibraryPath(classPathProcessor.buildForemostClasspathBasedOnCurrentClassLoader(LOGGER)) + File.pathSeparator + this.getHomeLibraryPath(classPathProcessor.buildPatchClasspathBasedOnCurrentClassLoader(LOGGER)) + File.pathSeparator + builder.buildCustomClassPath(true);
            grinderJVMClassPath = ((String)grinderJVMClassPath).replace(";;", ";");
            properties.setProperty("grinder.jvm.classpath", (String)grinderJVMClassPath);
            LOGGER.info("grinder.jvm.classpath : {} ", grinderJVMClassPath);
            AgentIdentityImplementation agentIdentity = new AgentIdentityImplementation("validation");
            agentIdentity.setNumber(0);
            String newClassPath = classPathProcessor.buildClasspathBasedOnCurrentClassLoader(LOGGER);
            LOGGER.debug("validation class path " + newClassPath);
            Properties systemProperties = new Properties();
            Object path = this.isRunningOnWas() ? this.getHomeLibraryPath(newClassPath) : this.runtimeClassPath() + newClassPath;
            systemProperties.put("java.class.path", path);
            Directory workingDirectory = new Directory(base);
            String buildJVMArgumentWithoutMemory = builder.buildJVMArgumentWithoutMemory();
            LOGGER.info("jvm args : {} ", (Object)buildJVMArgumentWithoutMemory);
            WorkerProcessCommandLine workerCommandLine = new WorkerProcessCommandLine(properties, systemProperties, buildJVMArgumentWithoutMemory, workingDirectory);
            ScriptLocation scriptLocation = new ScriptLocation(workingDirectory, script);
            ProcessWorkerFactory workerFactory = new ProcessWorkerFactory(workerCommandLine, agentIdentity, fanOutStreamSender, false, scriptLocation, properties);
            workerLauncher = new ErrorStreamRedirectWorkerLauncher(1, (WorkerFactory)workerFactory, eventSynchronisation, LOGGER, byteArrayErrorStream);
            workerLauncher.startAllWorkers();
            Condition condition = eventSynchronisation;
            synchronized (condition) {
                long sleep = 1000L;
                int waitingCount = 0;
                while (!workerLauncher.allFinished()) {
                    if (waitingCount++ > timeout) {
                        LOGGER.error("Validation should be performed within {} sec. Stop it by force", (Object)timeout);
                        workerLauncher.destroyAllWorkers();
                        stopByTooMuchExecution = true;
                        break;
                    }
                    eventSynchronisation.waitNoInterrruptException(1000L);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while executing {} because {}", (Object)script, (Object)e.getMessage());
            LOGGER.info("The error detail is ", (Throwable)e);
            this.appendingMessageOn(file, ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        finally {
            if (workerLauncher != null) {
                workerLauncher.shutdown();
            }
            if (fanOutStreamSender != null) {
                fanOutStreamSender.shutdown();
            }
            int waitingCount = 0;
            while (workerLauncher != null) {
                int maximumWaitingCount = 10;
                if (workerLauncher.allFinished() || waitingCount++ > 10) break;
                Condition properties = eventSynchronisation;
                synchronized (properties) {
                    eventSynchronisation.waitNoInterrruptException(1000L);
                }
            }
        }
        this.appendingMessageOn(file, byteArrayErrorStream.toString());
        File errorValidation = new File(base, "error_validation-0.log");
        if (errorValidation.exists()) {
            String errorValidationResult = "";
            try {
                errorValidationResult = FileUtils.readFileToString((File)errorValidation);
            }
            catch (IOException e) {
                NoOp.noOp();
            }
            this.appendingMessageOn(file, errorValidationResult);
        }
        if (stopByTooMuchExecution) {
            this.appendingMessageOn(file, "Validation should be performed within " + timeout + " sec. Stop it by force");
        }
        return file;
    }

    private void deleteLogs(File base) {
        base.listFiles(pathName -> {
            String extension = FilenameUtils.getExtension((String)pathName.getName());
            if (extension.startsWith("log")) {
                pathName.delete();
            }
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendingMessageOn(File file, String msg) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file, true);
            fileWriter.append("\n\n").append(msg);
        }
        catch (IOException e) {
            try {
                LOGGER.error("Error during appending validation messages", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fileWriter);
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    private String getHomeLibraryPath(String classPath) {
        StringBuilder homeLibraryPath = new StringBuilder();
        for (String path : classPath.split(File.pathSeparator)) {
            homeLibraryPath.append(this.requiredLibraryDirectory.getAbsolutePath()).append(File.separator).append(FilenameUtils.getName((String)path)).append(File.pathSeparator);
        }
        return homeLibraryPath.toString();
    }

    private boolean isRunningOnWas() {
        return AbstractGrinderClassPathProcessor.getClassPaths(LocalScriptTestDriveService.class.getClassLoader())[0].getProtocol().equals("jar");
    }

    private String runtimeClassPath() {
        StringBuilder runtimeClassPath = new StringBuilder();
        for (URL url : AbstractGrinderClassPathProcessor.getClassPaths(LocalScriptTestDriveService.class.getClassLoader())) {
            if (!url.getPath().contains("ngrinder-runtime") && !url.getPath().contains("ngrinder-groovy")) continue;
            runtimeClassPath.append(EncodingUtils.decodePathWithUTF8(url.getFile())).append(File.pathSeparator);
        }
        return runtimeClassPath.toString();
    }
}

