/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.grinder.common.GrinderProperties;
import net.grinder.util.Directory;
import net.grinder.util.NetworkUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.ngrinder.common.util.NoOp;
import org.ngrinder.common.util.Preconditions;
import org.ngrinder.common.util.SystemInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessBuilder.class);
    private static final Set<String> DISABLED_SSL_PROTOCOLS = new HashSet<String>(Collections.singletonList("SSLv2Hello"));
    private final GrinderProperties properties;
    private final Directory baseDirectory;
    private final String hostName;
    private final boolean securityEnabled;
    private final String securityLevel;
    private final String hostString;
    private final boolean server;
    private final boolean useXmxLimit;
    private final String additionalJavaOpt;
    private final boolean enableLocalDNS;
    protected static final long MIN_PER_PROCESS_MEM_SIZE = 0x3200000L;
    protected static final long DEFAULT_MAX_XMX_SIZE = 0x40000000L;

    public PropertyBuilder(GrinderProperties properties, Directory baseDirectory, boolean securityEnabled, String securityLevel, String hostString, String hostName, boolean server, boolean useXmxLimit, boolean enableLocalDNS, String additionalJavaOpt) {
        this.enableLocalDNS = enableLocalDNS;
        this.properties = Preconditions.checkNotNull(properties);
        this.baseDirectory = Preconditions.checkNotNull(baseDirectory);
        this.securityEnabled = securityEnabled;
        this.securityLevel = securityLevel;
        this.hostString = hostString;
        this.hostName = Preconditions.checkNotEmpty(hostName);
        this.server = server;
        this.useXmxLimit = useXmxLimit;
        this.additionalJavaOpt = additionalJavaOpt;
    }

    public PropertyBuilder(GrinderProperties properties, Directory baseDirectory, boolean securityEnabled, String securityLevel, String hostString, String hostName, boolean server, boolean useXmxLimit, String additionalJavaOpt) {
        this(properties, baseDirectory, securityEnabled, securityLevel, hostString, hostName, server, useXmxLimit, true, additionalJavaOpt);
    }

    public PropertyBuilder(GrinderProperties properties, Directory baseDirectory, boolean securityEnabled, String securityLevel, String hostString, String hostName, boolean server, boolean useXmxLimit) {
        this(properties, baseDirectory, securityEnabled, securityLevel, hostString, hostName, server, useXmxLimit, null);
    }

    public PropertyBuilder(GrinderProperties properties, Directory baseDirectory, boolean securityEnabled, String securityLevel, String hostString, String hostName, boolean server) {
        this(properties, baseDirectory, securityEnabled, securityLevel, hostString, hostName, server, true);
    }

    public PropertyBuilder(GrinderProperties properties, Directory baseDirectory, boolean securityEnabled, String securityLevel, String hostString, String hostName) {
        this(properties, baseDirectory, securityEnabled, securityLevel, hostString, hostName, false);
    }

    public String buildJVMArgument() {
        return this.addMemorySettings(new StringBuilder(this.buildJVMArgumentWithoutMemory())).toString();
    }

    public String buildJVMArgumentWithoutMemory() {
        String jdkVersion;
        StringBuilder jvmArguments = new StringBuilder();
        if (this.securityEnabled) {
            this.addSecurityManager(jvmArguments);
            this.addCurrentAgentPath(jvmArguments);
            this.addConsoleIP(jvmArguments);
            this.addDnsIP(jvmArguments);
        } else {
            jvmArguments.append(this.properties.getProperty("grinder.jvm.arguments", ""));
            this.addNativeLibraryPath(jvmArguments);
        }
        if (this.properties.getBoolean("grinder.connectionReset", false)) {
            jvmArguments.append(" -Dngrinder.connection.reset.on.each.test.run=true ");
        }
        this.addParam(jvmArguments, this.properties.getProperty("grinder.param", ""));
        this.addPythonPathJvmArgument(jvmArguments);
        this.addCustomDns(jvmArguments);
        this.addUserDir(jvmArguments);
        this.addContext(jvmArguments);
        this.addHttpsProtocols(jvmArguments);
        this.disableSNIExtension(jvmArguments);
        if (this.server) {
            this.addServerMode(jvmArguments);
        }
        if (StringUtils.isNotBlank((String)this.additionalJavaOpt)) {
            this.addAdditionalJavaOpt(jvmArguments);
        }
        if ((jdkVersion = System.getProperty("java.specification.version")) != null && !jdkVersion.startsWith("1.")) {
            jvmArguments.append(" --add-opens java.base/java.net=ALL-UNNAMED ");
        }
        return jvmArguments.toString();
    }

    protected StringBuilder disableSNIExtension(StringBuilder jvmArguments) {
        return jvmArguments.append(" -Djsse.enableSNIExtension=false ");
    }

    protected StringBuilder addHttpsProtocols(StringBuilder jvmArguments) {
        String[] sslProtocols = new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"};
        try {
            SSLSocket socket = (SSLSocket)SSLSocketFactory.getDefault().createSocket();
            sslProtocols = socket.getSupportedProtocols();
        }
        catch (IOException e) {
            NoOp.noOp();
        }
        ArrayList<String> protocols = new ArrayList<String>();
        for (String protocol : sslProtocols) {
            if (DISABLED_SSL_PROTOCOLS.contains(protocol)) continue;
            protocols.add(protocol);
        }
        return jvmArguments.append(" -Dhttps.protocols=").append(StringUtils.join(protocols, (String)",")).append(" ");
    }

    protected StringBuilder addContext(StringBuilder jvmArguments) {
        return jvmArguments.append(" -Dngrinder.context=agent ");
    }

    protected StringBuilder addParam(StringBuilder jvmArguments, String param) {
        if (StringUtils.isEmpty((String)param)) {
            return jvmArguments;
        }
        return jvmArguments.append(" -Dparam=").append(param).append(" ");
    }

    protected StringBuilder addAdditionalJavaOpt(StringBuilder jvmArguments) {
        return jvmArguments.append(" ").append(this.additionalJavaOpt).append(" ");
    }

    protected StringBuilder addNativeLibraryPath(StringBuilder jvmArguments) {
        return jvmArguments.append(" -Djna.library.path=").append(new File(this.baseDirectory.getFile(), "/lib")).append(" ");
    }

    protected StringBuilder addMemorySettings(StringBuilder jvmArguments) {
        String processCountStr = this.properties.getProperty("grinder.processes", "1");
        int reservedMemoryUnit = this.properties.getInt("grinder.reserved.memory", 0);
        if (reservedMemoryUnit == 0) {
            reservedMemoryUnit = this.properties.getInt("grinder.memory.reserved", 300);
        }
        int reservedMemory = Math.max(reservedMemoryUnit, 0) * 1024 * 1024;
        int processCount = NumberUtils.toInt((String)processCountStr, (int)1);
        long free = SystemInfoUtils.getAvailableMemory() - (long)reservedMemory;
        long perProcessTotalMemory = Math.max(free / (long)processCount, 0x3200000L);
        long desirableXmx = (long)((double)perProcessTotalMemory * 0.5);
        if (this.useXmxLimit) {
            desirableXmx = Math.min(0x40000000L, desirableXmx);
        }
        jvmArguments.append(" -Xms").append(this.getMemorySize(desirableXmx)).append("m -Xmx").append(this.getMemorySize(desirableXmx)).append("m ");
        return jvmArguments;
    }

    private int getMemorySize(long memoryInByte) {
        return (int)(memoryInByte / 0x100000L);
    }

    protected StringBuilder addServerMode(StringBuilder jvmArguments) {
        return jvmArguments.append(" -server ");
    }

    protected StringBuilder addSecurityManager(StringBuilder jvmArguments) {
        return jvmArguments.append(" -Djava.security.manager=").append(this.getSecurityManagerBySecurityLevel(this.securityLevel)).append(" ");
    }

    private String getSecurityManagerBySecurityLevel(String securityLevel) {
        if ("light".equalsIgnoreCase(securityLevel)) {
            return "org.ngrinder.sm.NGrinderLightSecurityManager";
        }
        return "org.ngrinder.sm.NGrinderSecurityManager";
    }

    private String getPath(File file, boolean useAbsolutePath) {
        return useAbsolutePath ? FilenameUtils.normalize((String)file.getAbsolutePath()) : file.getPath();
    }

    public String buildCustomClassPath(boolean useAbsolutePath) {
        File baseFile = this.baseDirectory.getFile();
        File libFolder = new File(baseFile, "lib");
        StringBuffer customClassPath = new StringBuffer();
        customClassPath.append(this.getPath(baseFile, useAbsolutePath));
        if (libFolder.exists()) {
            customClassPath.append(File.pathSeparator).append(this.getPath(new File(baseFile, "lib"), useAbsolutePath));
            libFolder.list((dir, name) -> {
                if (name.endsWith(".jar")) {
                    customClassPath.append(File.pathSeparator).append(this.getPath(new File(dir, name), useAbsolutePath));
                }
                return true;
            });
        }
        return customClassPath.toString();
    }

    public String rebaseUserLibraryClassPath(String classPath) {
        StringBuilder newClassPath = new StringBuilder();
        boolean isFirst = true;
        for (String each : StringUtils.split((String)classPath, (String)";:")) {
            File file = new File(this.baseDirectory.getFile(), each);
            if (!isFirst) {
                newClassPath.append(File.pathSeparator);
            }
            isFirst = false;
            newClassPath.append(FilenameUtils.normalize((String)file.getAbsolutePath()));
        }
        return newClassPath.toString();
    }

    private StringBuilder addPythonPathJvmArgument(StringBuilder jvmArguments) {
        String pythonHome;
        jvmArguments.append(" -Dpython.path=");
        jvmArguments.append(new File(this.baseDirectory.getFile(), "lib").getAbsolutePath());
        String pythonPath = System.getenv().get("PYTHONPATH");
        if (pythonPath != null) {
            jvmArguments.append(File.pathSeparator).append(pythonPath);
        }
        if ((pythonHome = System.getenv().get("PYTHONHOME")) != null) {
            jvmArguments.append(" -Dpython.home=");
            jvmArguments.append(pythonHome);
        }
        jvmArguments.append(" ");
        File jythonCache = new File(FileUtils.getTempDirectory(), "jython");
        jythonCache.mkdirs();
        jvmArguments.append(" -Dpython.cachedir=").append(jythonCache.getAbsolutePath()).append(" ");
        return jvmArguments;
    }

    private StringBuilder addCurrentAgentPath(StringBuilder jvmArguments) {
        return jvmArguments.append(" -Dngrinder.exec.path=").append(this.baseDirectory.getFile()).append(" ");
    }

    private StringBuilder addConsoleIP(StringBuilder jvmArguments) {
        return jvmArguments.append(" -Dngrinder.console.ip=").append(this.properties.getProperty("grinder.consoleHost", "127.0.0.1")).append(" ");
    }

    StringBuilder addDnsIP(StringBuilder jvmArguments) {
        try {
            List<String> dnsServers = NetworkUtils.getDnsServers();
            if (!dnsServers.isEmpty()) {
                return jvmArguments.append(" -Dngrinder.dns.ip=").append(StringUtils.join(dnsServers, (String)",")).append(" ");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while adding DNS IPs for the security mode. This might be occurred by not using Oracle JDK : {}", (Object)e.getMessage());
        }
        return jvmArguments;
    }

    private StringBuilder addCustomDns(StringBuilder jvmArguments) {
        jvmArguments.append(" -Dngrinder.etc.hosts=").append(this.hostName).append(":127.0.0.1,localhost:127.0.0.1");
        if (StringUtils.isNotEmpty((String)this.hostString)) {
            jvmArguments.append(",").append(this.rebaseHostString(this.hostString));
        }
        if (this.enableLocalDNS) {
            jvmArguments.append(" -Dngrinder.enable.local-dns=true ");
        }
        return jvmArguments;
    }

    private StringBuilder addUserDir(StringBuilder jvmArguments) {
        jvmArguments.append(" -Duser.dir=").append(this.baseDirectory.getFile().getPath()).append(" ");
        return jvmArguments;
    }

    public String rebaseHostString(String hostString) {
        String[] split = StringUtils.split((String)hostString, (String)",");
        StringBuilder newHostString = new StringBuilder();
        boolean first = true;
        for (String pair : split) {
            if (!first) {
                newHostString.append(",");
            }
            first = false;
            if (pair.startsWith(":")) {
                newHostString.append(pair);
                continue;
            }
            if (pair.contains(":")) {
                newHostString.append(pair);
                continue;
            }
            if (!this.securityEnabled) continue;
            boolean eachFirst = true;
            for (InetAddress each : NetworkUtils.getIpsFromHost(pair)) {
                if (!eachFirst) {
                    newHostString.append(",");
                }
                newHostString.append(pair).append(":").append(each.getHostAddress());
                eachFirst = false;
            }
        }
        return newHostString.toString();
    }

    void addProperties(String key, String value) {
        this.properties.put((Object)key, (Object)value);
    }
}

