/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.common;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import net.grinder.communication.ConnectionType;
import net.grinder.communication.Connector;

public class AgentControllerConnectorFactory {
    private final ConnectionType m_connectionType;

    public AgentControllerConnectorFactory(ConnectionType connectionType) {
        this.m_connectionType = connectionType;
    }

    public Connector create(String host, int port) {
        return new Connector(host, port, this.m_connectionType);
    }

    public Connector create(int port) {
        Connector connector;
        ServerSocket serverSocket = new ServerSocket(port);
        try {
            Socket socket = serverSocket.accept();
            connector = new Connector(socket, this.m_connectionType);
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Fail to create connector", e);
            }
        }
        serverSocket.close();
        return connector;
    }
}

