/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.message.console;

import net.grinder.common.processidentity.AgentIdentity;
import net.grinder.communication.Address;
import net.grinder.communication.AddressAwareMessage;
import net.grinder.communication.CommunicationException;
import net.grinder.message.console.AgentControllerState;
import net.grinder.messages.console.AgentAddress;
import org.ngrinder.monitor.controller.model.SystemDataModel;

public class AgentControllerProcessReportMessage
implements AddressAwareMessage {
    private static final long serialVersionUID = 4L;
    private final AgentControllerState m_state;
    private transient AgentAddress m_processAddress;
    private final SystemDataModel systemDataModel;
    private final int connectingPort;
    private final String version;

    public AgentControllerProcessReportMessage(AgentControllerState state, SystemDataModel systemDataModel, int connectingPort, String version) {
        this.m_state = state;
        this.systemDataModel = systemDataModel;
        this.connectingPort = connectingPort;
        this.version = version;
    }

    public void setAddress(Address address) throws CommunicationException {
        try {
            this.m_processAddress = (AgentAddress)address;
        }
        catch (ClassCastException e) {
            throw new CommunicationException("Not an agent process address", (Throwable)e);
        }
    }

    public AgentAddress getProcessAddress() {
        return this.m_processAddress;
    }

    public AgentIdentity getAgentIdentity() {
        return (AgentIdentity)this.m_processAddress.getIdentity();
    }

    public AgentControllerState getState() {
        return this.m_state;
    }

    public SystemDataModel getSystemDataModel() {
        return this.systemDataModel;
    }

    public int getConnectingPort() {
        return this.connectingPort;
    }

    public String getVersion() {
        return this.version;
    }
}

