/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.message.console;

import com.fasterxml.jackson.annotation.JsonFormat;
import net.grinder.message.console.AgentStatusCategory;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum AgentControllerState {
    STARTED(AgentStatusCategory.READY),
    READY(AgentStatusCategory.READY),
    BUSY(AgentStatusCategory.PROGRESSING),
    FINISHED(AgentStatusCategory.READY),
    UPDATING(AgentStatusCategory.PROGRESSING),
    UNKNOWN(AgentStatusCategory.INACTIVE);

    private final AgentStatusCategory category;

    private AgentControllerState(AgentStatusCategory category) {
        this.category = category;
    }

    public AgentStatusCategory getCategory() {
        return this.category;
    }

    public String getIconName() {
        return this.category.getIconName();
    }

    public boolean isActive() {
        return this.category.isActive();
    }

    public boolean isReady() {
        return this.category == AgentStatusCategory.READY;
    }

    public String getName() {
        return this.name();
    }
}

