/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.ngrinder.common.exception.NGrinderRuntimeException;
import org.ngrinder.common.util.PathUtils;
import org.ngrinder.common.util.StreamUtils;

public class FileUtils {
    public static List<File> getAllFilesInDirectory(String directoryPath) throws IOException {
        try (Stream<Path> walk = Files.walk(Paths.get(directoryPath, new String[0]), new FileVisitOption[0]);){
            List<File> list = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).collect(Collectors.toList());
            return list;
        }
    }

    public static List<File> getAllFilesInDirectory(File directory) throws IOException {
        return FileUtils.getAllFilesInDirectory(directory.getPath());
    }

    public static Set<String> getMd5(List<File> files) {
        return files.stream().map(StreamUtils.exceptionWrapper(FileUtils::getMd5)).collect(Collectors.toSet());
    }

    public static String getMd5(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String string = DigestUtils.md5Hex((InputStream)fileInputStream);
            return string;
        }
    }

    public static String getFileDigest(File baseDir, File file) {
        try {
            return PathUtils.getSubPath(baseDir.getPath(), file.getPath()) + ":" + FileUtils.getMd5(file);
        }
        catch (IOException e) {
            throw new NGrinderRuntimeException(e);
        }
    }

    public static Set<String> getFilesDigest(File baseDir, List<File> files) {
        return files.stream().map(file -> FileUtils.getFileDigest(baseDir, file)).collect(Collectors.toSet());
    }
}

