/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class VersionNumber
implements Comparable<VersionNumber> {
    private final int[] digits;

    public VersionNumber(String num) {
        StringTokenizer tokens = new StringTokenizer(num, ".-_");
        this.digits = new int[tokens.countTokens()];
        if (this.digits.length < 2) {
            throw new IllegalArgumentException("Failed to parse " + num + " as version number");
        }
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().toLowerCase();
            if (token.equals("*")) {
                this.digits[i++] = 1000;
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)token, (String)"snapshot")) {
                int n = i - 1;
                this.digits[n] = this.digits[n] - 1;
                this.digits[i++] = 1000;
                break;
            }
            if (!NumberUtils.isNumber((String)token)) continue;
            this.digits[i++] = Integer.parseInt(token);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.digits.length; ++i) {
            if (i != 0) {
                buf.append('.');
            }
            buf.append(this.digits[i]);
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        return o instanceof VersionNumber && this.compareTo((VersionNumber)o) == 0;
    }

    public int hashCode() {
        int x = 0;
        for (int i : this.digits) {
            x = x << 1 | i;
        }
        return x;
    }

    @Override
    public int compareTo(VersionNumber rhs) {
        int i = 0;
        while (i != this.digits.length || i != rhs.digits.length) {
            if (i == this.digits.length) {
                return -1;
            }
            if (i == rhs.digits.length) {
                return 1;
            }
            int r = this.digits[i] - rhs.digits[i];
            if (r != 0) {
                return r;
            }
            ++i;
        }
        return 0;
    }
}

