/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public abstract class DateUtils {
    private static final int CONSTANT_10 = 10;
    private static final int CONSTANT_24 = 24;
    private static final int CONSTANT_60 = 60;
    private static final int CONSTANT_1000 = 1000;
    private static final int SS = 1000;
    private static final int MI = 60000;
    private static final int HH = 3600000;
    private static final int DD = 86400000;
    private static Map<String, String> timezoneIDMap;

    public static long getCollectTimeInLong(Date date) {
        SimpleDateFormat collectTimeFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return Long.parseLong(collectTimeFormat.format(date));
    }

    public static Date convertToServerDate(String userTimeZone, Date userDate) {
        TimeZone userLocal = TimeZone.getTimeZone(userTimeZone);
        int rawOffset = TimeZone.getDefault().getRawOffset() - userLocal.getRawOffset();
        return new Date(userDate.getTime() + (long)rawOffset);
    }

    public static Date convertToUserDate(String userTimeZone, Date serverDate) {
        TimeZone userLocal = TimeZone.getTimeZone(userTimeZone);
        int rawOffset = userLocal.getRawOffset() - TimeZone.getDefault().getRawOffset();
        return new Date(serverDate.getTime() + (long)rawOffset);
    }

    public static String dateToString(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).format(date);
    }

    public static Map<String, String> getFilteredTimeZoneMap() {
        if (timezoneIDMap == null) {
            String[] ids;
            timezoneIDMap = new LinkedHashMap<String, String>();
            for (String id : ids = TimeZone.getAvailableIDs()) {
                TimeZone zone = TimeZone.getTimeZone(id);
                int offset = zone.getRawOffset();
                int offsetSecond = offset / 1000;
                int hour = offsetSecond / 3600;
                int minutes = offsetSecond % 3600 / 60;
                timezoneIDMap.put(TimeZone.getTimeZone(id).getDisplayName(), String.format("(GMT%+d:%02d) %s", hour, minutes, id));
            }
        }
        return timezoneIDMap;
    }

    public static Date toSimpleDate(String strDate) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        return simpleDateFormat.parse(strDate);
    }

    public static Date toDate(String strDate) throws ParseException {
        SimpleDateFormat fullDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        return fullDateFormat.parse(strDate);
    }

    public static Date addDay(Date date, int days) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(6, days);
        return cal.getTime();
    }

    public static String ms2Time(long ms) {
        long day = ms / 86400000L;
        long hour = (ms - day * 86400000L) / 3600000L;
        long minute = (ms - day * 86400000L - hour * 3600000L) / 60000L;
        long second = (ms - day * 86400000L - hour * 3600000L - minute * 60000L) / 1000L;
        Object strDay = day < 10L ? "0" + day : "" + day;
        String strHour = hour < 10L ? "0" + hour : "" + hour;
        String strMinute = minute < 10L ? "0" + minute : "" + minute;
        String strSecond = second < 10L ? "0" + second : "" + second;
        strDay = StringUtils.equals((String)strDay, (String)"00") ? "" : (String)strDay + ":";
        return (String)strDay + strHour + ":" + strMinute + ":" + strSecond;
    }

    public static long timeToMs(int day, int hour, int min, int sec) {
        return 1000L * (long)(((day * 24 + hour) * 60 + min) * 60 + sec);
    }

    public static boolean compareDateEndWithMinute(Date d1, Date d2) {
        SimpleDateFormat dateFormatEndWithMinute = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String s1 = dateFormatEndWithMinute.format(d1);
        String s2 = dateFormatEndWithMinute.format(d2);
        return s1.equals(s2);
    }
}

