/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.ngrinder.common.util.ExceptionUtils;

public abstract class EncodingUtils {
    public static String encodePathWithUTF8(String path) {
        try {
            StringBuilder result = new StringBuilder();
            for (char each : path.toCharArray()) {
                if (each == '/') {
                    result.append("/");
                    continue;
                }
                result.append(URLEncoder.encode(String.valueOf(each), "UTF-8"));
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionUtils.processException(e);
        }
    }

    public static String decodePathWithUTF8(String path) {
        try {
            return URLDecoder.decode(path, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionUtils.processException(e);
        }
    }
}

