/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.common.util;

import com.sun.jna.Platform;
import java.util.List;
import org.ngrinder.monitor.share.domain.BandWidth;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.util.ExecutingCommand;

public class SystemInfoUtils {
    private static final OperatingSystem operatingSystem;
    private static final CentralProcessor centralProcessor;
    private static final GlobalMemory globalMemory;
    private static final List<NetworkIF> networkIFs;
    private static long[] prevTicks;

    public static OSProcess getProcess(int pid) {
        return operatingSystem.getProcess(pid);
    }

    public static List<String> killProcess(int pid) {
        return Platform.isWindows() ? ExecutingCommand.runNative((String)("taskkill /f /pid " + pid)) : ExecutingCommand.runNative((String)("kill -9 " + pid));
    }

    public static int getPid() {
        return operatingSystem.getProcessId();
    }

    public static long getAvailableMemory() {
        return globalMemory.getAvailable();
    }

    public static long getTotalMemory() {
        return globalMemory.getTotal();
    }

    public static float getCpuUsedPercentage() {
        float cpuUsedPercentage = (float)centralProcessor.getSystemCpuLoadBetweenTicks(prevTicks) * 100.0f;
        prevTicks = centralProcessor.getSystemCpuLoadTicks();
        return cpuUsedPercentage;
    }

    public static BandWidth getNetworkUsage() {
        long rx = 0L;
        long tx = 0L;
        if (!networkIFs.isEmpty()) {
            for (NetworkIF net : networkIFs) {
                net.updateAttributes();
                rx += net.getBytesRecv();
                tx += net.getBytesSent();
            }
        }
        return SystemInfoUtils.getBandWidth(rx, tx);
    }

    private static BandWidth getBandWidth(long rx, long tx) {
        BandWidth bandWidth = new BandWidth(System.currentTimeMillis());
        bandWidth.setReceived(bandWidth.getReceived() + rx);
        bandWidth.setSent(bandWidth.getSent() + tx);
        return bandWidth;
    }

    static {
        SystemInfo systemInfo = new SystemInfo();
        HardwareAbstractionLayer hardware = systemInfo.getHardware();
        operatingSystem = systemInfo.getOperatingSystem();
        networkIFs = hardware.getNetworkIFs();
        centralProcessor = hardware.getProcessor();
        globalMemory = hardware.getMemory();
        prevTicks = centralProcessor.getSystemCpuLoadTicks();
    }
}

