/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.model;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.ngrinder.common.util.ExceptionUtils;
import org.ngrinder.common.util.ReflectionUtils;
import org.ngrinder.model.Cloneable;

@MappedSuperclass
public class BaseEntity<M>
implements Serializable {
    private static final long serialVersionUID = 8571113820348514692L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false, updatable=false)
    private Long id;

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean exist() {
        return this.id != null && this.id != 0L;
    }

    public M merge(M source) {
        Field forDisplay = null;
        try {
            List<Field> fields = ReflectionUtils.getDeclaredFieldsIncludingParent(this.getClass());
            for (Field each : fields) {
                Object value;
                int modifiers;
                if (each.isSynthetic() || Modifier.isFinal(modifiers = each.getModifiers()) || Modifier.isStatic(modifiers)) continue;
                forDisplay = each;
                if (!each.isAccessible()) {
                    each.setAccessible(true);
                }
                if ((value = each.get(source)) == null) continue;
                each.set(this, value);
            }
            return (M)this;
        }
        catch (Exception e) {
            String displayName = forDisplay == null ? "Empty" : forDisplay.getName();
            throw ExceptionUtils.processException(displayName + " - Exception occurred while merging an entity from " + source + " to " + this, e);
        }
    }

    public M cloneTo(M toInstance) {
        Field forDisplay = null;
        try {
            Field[] fields;
            for (Field each : fields = this.getClass().getDeclaredFields()) {
                int modifiers;
                if (each.isSynthetic() || Modifier.isFinal(modifiers = each.getModifiers()) || Modifier.isStatic(modifiers)) continue;
                forDisplay = each;
                Cloneable annotation = each.getAnnotation(Cloneable.class);
                if (annotation == null) continue;
                if (!each.isAccessible()) {
                    each.setAccessible(true);
                }
                each.set(toInstance, each.get(this));
            }
            return toInstance;
        }
        catch (Exception e) {
            String displayName = forDisplay == null ? "Empty" : forDisplay.getName();
            throw ExceptionUtils.processException(displayName + " - Exception occurred while cloning an entity from " + this + " to " + toInstance, e);
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

