/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.monitor.agent;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashSet;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import net.grinder.util.NetworkUtils;
import org.apache.commons.lang.StringUtils;
import org.ngrinder.common.constants.MonitorConstants;
import org.ngrinder.infra.AgentConfig;
import org.ngrinder.monitor.MonitorContext;
import org.ngrinder.monitor.agent.RegisterMXBean;
import org.ngrinder.monitor.collector.DataCollectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MonitorServer
implements MonitorConstants {
    private static final Logger LOG = LoggerFactory.getLogger(MonitorServer.class);
    private JMXConnectorServer jmxServer = null;
    private Registry rmiRegistry = null;
    private boolean isRunning = false;
    private AgentConfig agentConfig;
    private static final MonitorServer INSTANCE = new MonitorServer();

    private MonitorServer() {
    }

    public static MonitorServer getInstance() {
        return INSTANCE;
    }

    public void init(AgentConfig agentConfig) throws IOException {
        this.agentConfig = agentConfig;
        HashSet<String> systemDataCollector = new HashSet<String>();
        systemDataCollector.add("name=System");
        MonitorContext.getInstance().setDataCollectors(systemDataCollector);
        int port = agentConfig.getMonitorProperties().getPropertyInt("monitor.binding_port");
        this.rmiRegistry = LocateRegistry.createRegistry(port);
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        String hostname = agentConfig.getMonitorBindingIP();
        if (StringUtils.isBlank((String)hostname)) {
            hostname = NetworkUtils.getAllPBindingAddress();
        }
        String jmxUrlString = String.format("service:jmx:rmi://%s:%d/jndi/rmi://%s:%d/jmxrmi", hostname, port, hostname, port);
        JMXServiceURL jmxUrl = new JMXServiceURL(jmxUrlString);
        this.jmxServer = JMXConnectorServerFactory.newJMXConnectorServer(jmxUrl, null, mBeanServer);
        RegisterMXBean.getInstance().addDefaultMXBean(mBeanServer);
        LOG.info("Service URL:{} is initiated.", (Object)jmxUrl);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() throws IOException {
        if (!this.isRunning()) {
            this.jmxServer.start();
            DataCollectManager.getInstance().init(this.agentConfig);
            DataCollectManager.getInstance().start();
            this.isRunning = true;
        }
    }

    public void stop() {
        LOG.info("Stop monitor.");
        if (!this.isRunning) {
            LOG.info("Monitor was not started!");
            return;
        }
        this.isRunning = false;
        try {
            this.jmxServer.stop();
            DataCollectManager.getInstance().stop();
            UnicastRemoteObject.unexportObject(this.rmiRegistry, true);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

