/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.monitor.agent;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.ngrinder.common.constants.MonitorConstants;
import org.ngrinder.common.util.ExceptionUtils;
import org.ngrinder.monitor.MonitorContext;
import org.ngrinder.monitor.agent.MXBeanStorage;
import org.ngrinder.monitor.mxbean.SystemMonitoringData;
import org.ngrinder.monitor.mxbean.core.MXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegisterMXBean
implements MonitorConstants {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterMXBean.class);
    private static final RegisterMXBean INSTANCE = new RegisterMXBean();

    private RegisterMXBean() {
    }

    public void addDefaultMXBean(MBeanServer mbeanServer) {
        Set<String> dataCollectors = MonitorContext.getInstance().getDataCollectors();
        if (dataCollectors.contains("name=System")) {
            this.addMXBean(mbeanServer, "name=System", new SystemMonitoringData());
        }
        LOG.info("Default MXBean Initialized.");
    }

    void addMXBean(MBeanServer mbeanServer, String subDomainName, MXBean bean) {
        ObjectName objectName;
        try {
            objectName = new ObjectName("org.ngrinder.monitor:" + subDomainName);
            mbeanServer.registerMBean(bean, objectName);
        }
        catch (Exception e) {
            throw ExceptionUtils.processException(e.getMessage(), e);
        }
        MXBeanStorage.getInstance().addMXBean(subDomainName, bean);
        LOG.info("Added MXBean:{}.", (Object)objectName);
    }

    public static RegisterMXBean getInstance() {
        return INSTANCE;
    }
}

