/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.monitor.share.domain;

import java.io.Serializable;

public class BandWidth
implements Serializable {
    private static final long serialVersionUID = 7655104078722834344L;
    private long time;
    private long received;
    private long sent;
    private long receivedPerSec;
    private long sentPerSec;

    public BandWidth() {
    }

    public BandWidth(long time) {
        this.time = time;
    }

    public BandWidth adjust(BandWidth bandWidth) {
        float rate = (float)Math.abs(this.time - bandWidth.getTime()) / 1000.0f;
        this.receivedPerSec = (long)((float)(this.received - bandWidth.getReceived()) / rate);
        this.sentPerSec = (long)((float)(this.sent - bandWidth.getSent()) / rate);
        return this;
    }

    public long getTime() {
        return this.time;
    }

    public long getReceived() {
        return this.received;
    }

    public long getSent() {
        return this.sent;
    }

    public long getReceivedPerSec() {
        return this.receivedPerSec;
    }

    public long getSentPerSec() {
        return this.sentPerSec;
    }

    public void setReceived(long received) {
        this.received = received;
    }

    public void setSent(long sent) {
        this.sent = sent;
    }

    public void setReceivedPerSec(long receivedPerSec) {
        this.receivedPerSec = receivedPerSec;
    }

    public void setSentPerSec(long sentPerSec) {
        this.sentPerSec = sentPerSec;
    }

    public String toString() {
        return "BandWidth(time=" + this.getTime() + ", received=" + this.getReceived() + ", sent=" + this.getSent() + ", receivedPerSec=" + this.getReceivedPerSec() + ", sentPerSec=" + this.getSentPerSec() + ")";
    }
}

