/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.BitSet;
import org.nucleus8583.core.Iso8583Field;

public final class Iso8583Binary
extends Iso8583Field {
    private static final long serialVersionUID = 3977789121124596289L;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Iso8583Binary(int id, int length) {
        super(id, 0, length << 1, 'n', ' ', "");
    }

    public void pack(Writer writer, BitSet value) throws IOException {
        int bitsIndex = 0;
        for (int i = 0; i < this.length; ++i) {
            int ivalue = 0;
            if (value.get(bitsIndex++)) {
                ivalue |= 8;
            }
            if (value.get(bitsIndex++)) {
                ivalue |= 4;
            }
            if (value.get(bitsIndex++)) {
                ivalue |= 2;
            }
            if (value.get(bitsIndex++)) {
                ivalue |= 1;
            }
            writer.write(HEX[ivalue]);
        }
    }

    public void pack(Writer writer, BitSet value, int length) throws IOException {
        int bitsIndex = 0;
        length <<= 1;
        for (int i = 0; i < length; ++i) {
            int ivalue = 0;
            if (value.get(bitsIndex++)) {
                ivalue |= 8;
            }
            if (value.get(bitsIndex++)) {
                ivalue |= 4;
            }
            if (value.get(bitsIndex++)) {
                ivalue |= 2;
            }
            if (value.get(bitsIndex++)) {
                ivalue |= 1;
            }
            writer.write(HEX[ivalue]);
        }
    }

    public void pack(Writer writer, String value) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void unpackBinary(Reader reader, BitSet bits) throws IOException {
        int bitsIndex = 0;
        bits.clear();
        int i = 0;
        while (i < this.length) {
            int ichar = reader.read();
            if (ichar < 0) {
                throw new EOFException();
            }
            switch ((char)ichar) {
                case '0': {
                    break;
                }
                case '1': {
                    bits.set(bitsIndex + 3);
                    break;
                }
                case '2': {
                    bits.set(bitsIndex + 2);
                    break;
                }
                case '3': {
                    bits.set(bitsIndex + 2);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case '4': {
                    bits.set(bitsIndex + 1);
                    break;
                }
                case '5': {
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case '6': {
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 2);
                    break;
                }
                case '7': {
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 2);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case '8': {
                    bits.set(bitsIndex);
                    break;
                }
                case '9': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case 'A': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 2);
                    break;
                }
                case 'B': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 2);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case 'C': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 1);
                    break;
                }
                case 'D': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case 'E': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 2);
                    break;
                }
                case 'F': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 2);
                    bits.set(bitsIndex + 3);
                }
            }
            ++i;
            bitsIndex += 4;
        }
    }

    public void unpackBinary(Reader reader, BitSet bits, int off, int length) throws IOException {
        int bitsIndex = off << 3;
        length <<= 1;
        int i = 0;
        while (i < length) {
            int ichar = reader.read();
            if (ichar < 0) {
                throw new EOFException();
            }
            switch ((char)ichar) {
                case '0': {
                    break;
                }
                case '1': {
                    bits.set(bitsIndex + 3);
                    break;
                }
                case '2': {
                    bits.set(bitsIndex + 2);
                    break;
                }
                case '3': {
                    bits.set(bitsIndex + 2);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case '4': {
                    bits.set(bitsIndex + 1);
                    break;
                }
                case '5': {
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case '6': {
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 2);
                    break;
                }
                case '7': {
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 2);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case '8': {
                    bits.set(bitsIndex);
                    break;
                }
                case '9': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case 'A': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 2);
                    break;
                }
                case 'B': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 2);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case 'C': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 1);
                    break;
                }
                case 'D': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case 'E': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 2);
                    break;
                }
                case 'F': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 2);
                    bits.set(bitsIndex + 3);
                }
            }
            ++i;
            bitsIndex += 4;
        }
    }

    public BitSet unpackBinary(Reader reader) throws IOException {
        int bitsIndex = 0;
        BitSet bits = new BitSet();
        int i = 0;
        while (i < this.length) {
            int ichar = reader.read();
            if (ichar < 0) {
                throw new EOFException();
            }
            switch ((char)ichar) {
                case '0': {
                    break;
                }
                case '1': {
                    bits.set(bitsIndex + 3);
                    break;
                }
                case '2': {
                    bits.set(bitsIndex + 2);
                    break;
                }
                case '3': {
                    bits.set(bitsIndex + 2);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case '4': {
                    bits.set(bitsIndex + 1);
                    break;
                }
                case '5': {
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case '6': {
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 2);
                    break;
                }
                case '7': {
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 2);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case '8': {
                    bits.set(bitsIndex);
                    break;
                }
                case '9': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case 'A': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 2);
                    break;
                }
                case 'B': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 2);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case 'C': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 1);
                    break;
                }
                case 'D': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 3);
                    break;
                }
                case 'E': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 2);
                    break;
                }
                case 'F': {
                    bits.set(bitsIndex);
                    bits.set(bitsIndex + 1);
                    bits.set(bitsIndex + 2);
                    bits.set(bitsIndex + 3);
                }
            }
            ++i;
            bitsIndex += 4;
        }
        return bits;
    }

    public String unpackString(Reader packed) throws IOException {
        throw new UnsupportedOperationException();
    }
}

