/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.BitSet;

public abstract class Iso8583Field
implements Serializable {
    private static final long serialVersionUID = -1162912563090715434L;
    protected final int id;
    protected final int lcount;
    protected final int length;
    protected final char align;
    protected final char padWith;
    protected final char[] padder;
    protected final String emptyValue;
    protected final char[] cEmptyValue;

    public Iso8583Field(int id, int lcount, int length, char align, char padWith, String emptyValue) {
        this.id = id;
        this.lcount = lcount;
        this.length = length;
        this.align = align;
        this.padWith = padWith;
        this.padder = new char[length];
        Arrays.fill(this.padder, padWith);
        this.emptyValue = emptyValue;
        this.cEmptyValue = emptyValue.toCharArray();
    }

    protected void pad(Writer writer, String value, int valueLength) throws IOException {
        if (valueLength == 0) {
            writer.write(this.padder, 0, this.length);
        } else if (valueLength == this.length) {
            writer.write(value, 0, valueLength);
        } else {
            switch (this.align) {
                case 'l': {
                    writer.write(value, 0, valueLength);
                    writer.write(this.padder, 0, this.length - valueLength);
                    break;
                }
                case 'r': {
                    writer.write(this.padder, 0, this.length - valueLength);
                    writer.write(value, 0, valueLength);
                    break;
                }
                default: {
                    writer.write(value, 0, valueLength);
                    writer.write(this.padder, 0, this.length - valueLength);
                }
            }
        }
    }

    protected char[] unpad(char[] value, int valueLength) {
        char[] cbuf;
        switch (this.align) {
            case 'l': {
                int cbufLength = 0;
                for (int i = valueLength - 1; i >= 0; --i) {
                    if (value[i] == this.padWith) continue;
                    cbufLength = i + 1;
                    break;
                }
                if (cbufLength == 0) {
                    cbuf = this.cEmptyValue;
                    break;
                }
                if (cbufLength == valueLength) {
                    cbuf = value;
                    break;
                }
                cbuf = new char[cbufLength];
                System.arraycopy(value, 0, cbuf, 0, cbufLength);
                break;
            }
            case 'r': {
                int padLength = valueLength;
                for (int i = 0; i < valueLength; ++i) {
                    if (value[i] == this.padWith) continue;
                    padLength = i;
                    break;
                }
                if (padLength == 0) {
                    cbuf = value;
                    break;
                }
                if (padLength == valueLength) {
                    cbuf = this.cEmptyValue;
                    break;
                }
                int cbufLength = valueLength - padLength;
                cbuf = new char[cbufLength];
                System.arraycopy(value, padLength, cbuf, 0, cbufLength);
                break;
            }
            default: {
                cbuf = value;
            }
        }
        return cbuf;
    }

    public int getId() {
        return this.id;
    }

    public int getLength() {
        return this.length;
    }

    protected void read(Reader reader, char[] cbuf, int length) throws IOException {
        int cbufWriteIndex = 0;
        int remaining = length;
        while (remaining > 0) {
            int nbread = reader.read(cbuf, cbufWriteIndex, remaining);
            if (nbread == -1) {
                throw new EOFException();
            }
            remaining -= nbread;
            cbufWriteIndex += nbread;
        }
    }

    public abstract void pack(Writer var1, String var2) throws IOException;

    public abstract void pack(Writer var1, BitSet var2) throws IOException;

    public abstract void pack(Writer var1, BitSet var2, int var3) throws IOException;

    public abstract void unpackBinary(Reader var1, BitSet var2) throws IOException;

    public abstract void unpackBinary(Reader var1, BitSet var2, int var3, int var4) throws IOException;

    public abstract BitSet unpackBinary(Reader var1) throws IOException;

    public abstract String unpackString(Reader var1) throws IOException;
}

