/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import org.nucleus8583.core.Iso8583Field;
import org.nucleus8583.core.Iso8583MessageFactory;
import org.nucleus8583.core.charset.spi.CharsetProvider;
import org.nucleus8583.core.util.FastStringReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Iso8583Message
implements Serializable {
    private static final long serialVersionUID = -1503040549193848604L;
    private transient boolean hasMti;
    private transient Iso8583Field[] fields;
    private transient boolean[] binaries;
    private transient CharsetProvider charsetProvider;
    private int count;
    private String mti;
    private final String[] stringValues;
    private final BitSet[] binaryValues;
    private final BitSet bits1To128;
    private final BitSet bits129To192;

    public Iso8583Message() {
        this(192);
    }

    public Iso8583Message(int count) {
        if (count < 64 || count > 192) {
            throw new IllegalArgumentException("number of fields must in range 64-192");
        }
        this.hasMti = true;
        this.fields = null;
        this.binaries = null;
        this.charsetProvider = null;
        this.count = count + 1;
        this.mti = null;
        this.stringValues = new String[this.count];
        this.binaryValues = new BitSet[this.count];
        this.bits1To128 = new BitSet(128);
        this.bits129To192 = new BitSet(64);
    }

    public Iso8583Message(boolean hasMti, Iso8583Field[] fields, boolean[] binaries, CharsetProvider charsetProvider, int count) {
        this.hasMti = hasMti;
        this.fields = fields;
        this.binaries = binaries;
        this.charsetProvider = charsetProvider;
        this.count = count;
        this.mti = null;
        this.stringValues = new String[count];
        this.binaryValues = new BitSet[count];
        Arrays.fill(this.stringValues, null);
        Arrays.fill(this.binaryValues, null);
        this.bits1To128 = new BitSet(128);
        this.bits129To192 = new BitSet(64);
    }

    public void setMti(String mti) {
        if (mti == null || mti.length() != 4) {
            throw new IllegalArgumentException("mti is not valid, must be 4 characters length");
        }
        this.mti = mti;
    }

    public String getMti() {
        return this.mti;
    }

    public void set(int no, BitSet value) {
        if (no <= 1 || no > 192 || no == 65 || no >= this.count) {
            throw new IllegalArgumentException("field no must be in range 2-" + (this.count - 1) + " and not equals to 65");
        }
        if (this.binaries != null && !this.binaries[no]) {
            throw new IllegalArgumentException("field " + no + " is a string field.");
        }
        if (value == null) {
            this.unsafeUnset(no);
        } else {
            this.binaryValues[no] = value;
            this.stringValues[no] = null;
            if (no > 128) {
                this.bits129To192.set(no - 129);
            } else {
                this.bits1To128.set(no - 1);
            }
        }
    }

    public void set(int no, String value) {
        if (no == 0) {
            this.setMti(value);
            return;
        }
        if (no <= 1 || no > 192 || no == 65 || no >= this.count) {
            throw new IllegalArgumentException("field no must be in range 2-" + (this.count - 1) + " and not equals to 65");
        }
        if (this.binaries != null && this.binaries[no]) {
            throw new IllegalArgumentException("field " + no + " is a binary field.");
        }
        if (value == null) {
            this.unsafeUnset(no);
        } else {
            this.binaryValues[no] = null;
            this.stringValues[no] = value;
            if (no > 128) {
                this.bits129To192.set(no - 129);
            } else {
                this.bits1To128.set(no - 1);
            }
        }
    }

    public void unsafeSet(int no, String value) {
        this.binaryValues[no] = null;
        this.stringValues[no] = value;
        if (no > 128) {
            this.bits129To192.set(no - 129);
        } else {
            this.bits1To128.set(no - 1);
        }
    }

    public void unsafeSet(int no, BitSet value) {
        this.binaryValues[no] = value;
        this.stringValues[no] = null;
        if (no > 128) {
            this.bits129To192.set(no - 129);
        } else {
            this.bits1To128.set(no - 1);
        }
    }

    public void unset(int no) {
        if (no <= 1 || no > 192 || no == 65 || no >= this.count) {
            throw new IllegalArgumentException("field no must be in range 2-" + (this.count - 1) + " and not equals to 65");
        }
        if (no > 128) {
            this.bits129To192.clear(no - 129);
        } else {
            this.bits1To128.clear(no - 1);
        }
        this.binaryValues[no] = null;
        this.stringValues[no] = null;
    }

    public void unsafeUnset(int no) {
        if (no > 128) {
            this.bits129To192.clear(no - 129);
        } else {
            this.bits1To128.clear(no - 1);
        }
        this.binaryValues[no] = null;
        this.stringValues[no] = null;
    }

    public Object get(int no) {
        if (no == 0) {
            return this.getMti();
        }
        if (no <= 1 || no > 192 || no == 65 || no >= this.count) {
            throw new IllegalArgumentException("field no must be in range 2-" + (this.count - 1) + " and not equals to 65");
        }
        if (this.binaries == null) {
            BitSet value = this.binaryValues[no];
            if (value != null) {
                return value;
            }
            return this.stringValues[no];
        }
        if (this.binaries[no]) {
            return this.binaryValues[no];
        }
        return this.stringValues[no];
    }

    public String getString(int no) {
        if (no == 0) {
            return this.getMti();
        }
        if (no <= 1 || no > 192 || no == 65 || no >= this.count) {
            throw new IllegalArgumentException("field no must be in range 2-" + (this.count - 1) + " and not equals to 65");
        }
        if (this.binaries != null && this.binaries[no]) {
            throw new IllegalArgumentException("field " + no + " is a binary field");
        }
        return this.stringValues[no];
    }

    public BitSet getBinary(int no) {
        if (no <= 1 || no > 192 || no == 65 || no >= this.count) {
            throw new IllegalArgumentException("field no must be in range 2-" + (this.count - 1) + " and not equals to 65");
        }
        if (this.binaries != null && !this.binaries[no]) {
            throw new IllegalArgumentException("field " + no + " is a string field");
        }
        return this.binaryValues[no];
    }

    public String unsafeGetString(int no) {
        return this.stringValues[no];
    }

    public BitSet unsafeGetBinary(int no) {
        return this.binaryValues[no];
    }

    public void clear() {
        this.mti = null;
        Arrays.fill(this.binaryValues, null);
        Arrays.fill(this.stringValues, null);
        this.bits1To128.clear();
        this.bits129To192.clear();
    }

    public byte[] pack() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.pack(baos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public void pack(OutputStream out) throws IOException {
        this.pack(this.charsetProvider.createEncoder(out));
    }

    public void pack(Writer writer) throws IOException {
        boolean bit1IsOn = false;
        if (this.bits1To128.length() > 64) {
            this.bits1To128.set(0);
            bit1IsOn = true;
        } else {
            this.bits1To128.clear(0);
        }
        if (this.bits129To192.isEmpty()) {
            this.bits1To128.clear(64);
            this.binaryValues[65] = null;
            this.stringValues[65] = null;
        } else {
            if (!bit1IsOn) {
                this.bits1To128.set(0);
                bit1IsOn = true;
            }
            this.bits1To128.set(64);
            this.binaryValues[65] = this.bits129To192;
            this.stringValues[65] = null;
        }
        if (this.hasMti) {
            if (this.mti == null) {
                throw new IllegalArgumentException("mti must be set");
            }
            this.fields[0].pack(writer, this.mti);
        }
        this.fields[1].pack(writer, this.bits1To128, bit1IsOn ? 16 : 8);
        int i = 2;
        int j = 1;
        while (i < this.count && i < 129) {
            if (this.bits1To128.get(j)) {
                if (this.binaries[i]) {
                    this.fields[i].pack(writer, this.binaryValues[i]);
                } else {
                    this.fields[i].pack(writer, this.stringValues[i]);
                }
            }
            ++i;
            ++j;
        }
        i = 129;
        j = 0;
        while (i < this.count) {
            if (this.bits129To192.get(j)) {
                if (this.binaries[i]) {
                    this.fields[i].pack(writer, this.binaryValues[i]);
                } else {
                    this.fields[i].pack(writer, this.stringValues[i]);
                }
            }
            ++i;
            ++j;
        }
    }

    public void unpack(byte[] in) {
        try {
            this.unpack(new ByteArrayInputStream(in));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void unpack(String str) {
        try {
            this.unpack(new FastStringReader(str));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void unpack(InputStream in) throws IOException {
        this.unpack(this.charsetProvider.createDecoder(in));
    }

    public void unpack(Reader in) throws IOException {
        this.clear();
        if (this.hasMti) {
            this.mti = this.fields[0].unpackString(in);
        }
        this.fields[1].unpackBinary(in, this.bits1To128, 0, 8);
        if (this.bits1To128.get(0)) {
            this.fields[1].unpackBinary(in, this.bits1To128, 8, 8);
        }
        int i = 2;
        int iMin1 = 1;
        int iMin129 = -127;
        while (i < this.count) {
            if (i == 65) {
                if (this.bits1To128.get(64)) {
                    this.fields[i].unpackBinary(in, this.bits129To192);
                }
            } else if (i < 129) {
                if (this.bits1To128.get(iMin1)) {
                    if (this.binaries[i]) {
                        this.unsafeSet(i, this.fields[i].unpackBinary(in));
                    } else {
                        this.unsafeSet(i, this.fields[i].unpackString(in));
                    }
                }
            } else if (this.bits129To192.get(iMin129)) {
                if (this.binaries[i]) {
                    this.unsafeSet(i, this.fields[i].unpackBinary(in));
                } else {
                    this.unsafeSet(i, this.fields[i].unpackString(in));
                }
            }
            ++i;
            ++iMin1;
            ++iMin129;
        }
    }

    public void dump(Map<Integer, Object> map) {
        if (this.hasMti) {
            map.put(0, this.mti);
        }
        int i = 2;
        int iMin1 = 1;
        int iMin129 = -127;
        while (i < this.count) {
            if (i != 65) {
                BitSet value;
                if (i < 129) {
                    if (this.bits1To128.get(iMin1)) {
                        if (this.binaries == null) {
                            value = this.binaryValues[i];
                            if (value == null) {
                                map.put(i, this.stringValues[i]);
                            } else {
                                map.put(i, this.binaryValues[i]);
                            }
                        } else if (this.binaries[i]) {
                            map.put(i, this.binaryValues[i]);
                        } else {
                            map.put(i, this.stringValues[i]);
                        }
                    }
                } else if (this.bits129To192.get(iMin129)) {
                    if (this.binaries == null) {
                        value = this.binaryValues[i];
                        if (value == null) {
                            map.put(i, this.stringValues[i]);
                        } else {
                            map.put(i, this.binaryValues[i]);
                        }
                    } else if (this.binaries[i]) {
                        map.put(i, this.binaryValues[i]);
                    } else {
                        map.put(i, this.stringValues[i]);
                    }
                }
            }
            ++i;
            ++iMin1;
            ++iMin129;
        }
    }

    private boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public boolean equals(Object object) {
        int i;
        if (object == null) {
            return false;
        }
        if (!(object instanceof Iso8583Message)) {
            return false;
        }
        Iso8583Message another = (Iso8583Message)object;
        if (!this.equals(this.mti, another.mti)) {
            return false;
        }
        if (this.count != another.count) {
            return false;
        }
        for (i = this.count - 1; i >= 2; --i) {
            if (i == 65) continue;
            if (!this.equals(this.binaryValues[i], another.binaryValues[i])) {
                return false;
            }
            if (this.equals(this.stringValues[i], another.stringValues[i])) continue;
            return false;
        }
        if (this.binaries != null && another.binaries != null) {
            for (i = this.count - 1; i >= 2; --i) {
                if (i == 65 || this.binaries[i] == another.binaries[i]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<iso-message>\n");
        sbuf.append("    <iso-field id=\"0\" value=\"");
        sbuf.append(this.mti);
        sbuf.append("\" />\n");
        int i = 2;
        int iMin1 = 1;
        int iMin129 = -127;
        while (i < this.count) {
            if (i != 65) {
                BitSet val;
                if (i < 129) {
                    if (this.bits1To128.get(iMin1)) {
                        sbuf.append("    <iso-field id=\"");
                        sbuf.append(i);
                        sbuf.append("\" value=\"");
                        if (this.binaries == null) {
                            val = this.binaryValues[i];
                            if (val == null) {
                                sbuf.append(this.stringValues[i]);
                            } else {
                                sbuf.append(val);
                            }
                        } else if (this.binaries[i]) {
                            sbuf.append(this.binaryValues[i]);
                        } else {
                            sbuf.append(this.stringValues[i]);
                        }
                        sbuf.append("\" />\n");
                    }
                } else if (this.bits129To192.get(iMin129)) {
                    sbuf.append("    <iso-field id=\"");
                    sbuf.append(i);
                    sbuf.append("\" value=\"");
                    if (this.binaries == null) {
                        val = this.binaryValues[i];
                        if (val == null) {
                            sbuf.append(this.stringValues[i]);
                        } else {
                            sbuf.append(val);
                        }
                    } else if (this.binaries[i]) {
                        sbuf.append(this.binaryValues[i]);
                    } else {
                        sbuf.append(this.stringValues[i]);
                    }
                    sbuf.append("\" />\n");
                }
            }
            ++i;
            ++iMin1;
            ++iMin129;
        }
        sbuf.append("</iso-message>\n");
        return sbuf.toString();
    }

    public void attach(Iso8583MessageFactory factory) {
        this.hasMti = factory.hasMti();
        this.fields = factory.getFields();
        this.binaries = factory.getBinaries();
        this.charsetProvider = factory.getCharsetProvider();
        int count = this.fields.length;
        this.count = count > this.binaryValues.length ? this.binaryValues.length : count;
    }

    public void detach() {
        this.fields = null;
        this.binaries = null;
        this.charsetProvider = null;
        this.count = this.binaryValues.length;
    }
}

