/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.nucleus8583.core.Iso8583Field;
import org.nucleus8583.core.Iso8583Message;
import org.nucleus8583.core.charset.spi.CharsetProvider;
import org.nucleus8583.core.util.ResourceUtils;
import org.nucleus8583.core.xml.Iso8583MessageDefinition;
import org.w3c.dom.Node;

public final class Iso8583MessageFactory {
    private final Iso8583MessageDefinition definition;
    private static final JAXBContext ctx;
    private static final Schema xsd;

    public Iso8583MessageFactory(String location) {
        URL found = ResourceUtils.getURL(location);
        if (found == null) {
            throw new RuntimeException("unable to find " + location);
        }
        try {
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            unmarshaller.setSchema(xsd);
            this.definition = (Iso8583MessageDefinition)unmarshaller.unmarshal(found);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.definition.createMessageTemplate();
    }

    public Iso8583MessageFactory(InputStream in) {
        try {
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            unmarshaller.setSchema(xsd);
            this.definition = (Iso8583MessageDefinition)unmarshaller.unmarshal(in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.definition.createMessageTemplate();
    }

    public Iso8583MessageFactory(Node node) {
        try {
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            unmarshaller.setSchema(xsd);
            this.definition = (Iso8583MessageDefinition)unmarshaller.unmarshal(node);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.definition.createMessageTemplate();
    }

    public static Iso8583MessageFactory create(String location) {
        return new Iso8583MessageFactory(location);
    }

    public static Iso8583MessageFactory create(InputStream in) {
        return new Iso8583MessageFactory(in);
    }

    public static Iso8583MessageFactory create(Node node) {
        return new Iso8583MessageFactory(node);
    }

    public Iso8583Message createMessage() {
        return this.definition.createMessage();
    }

    public String getEncoding() {
        return this.definition.getEncoding();
    }

    public CharsetProvider getCharsetProvider() {
        return this.definition.getCharsetProvider();
    }

    public boolean hasMti() {
        return this.definition.hasMti();
    }

    public Iso8583Field[] getFields() {
        return this.definition.getFields();
    }

    public boolean[] getBinaries() {
        return this.definition.getBinaries();
    }

    static {
        try {
            ctx = JAXBContext.newInstance((Class[])new Class[]{Iso8583MessageDefinition.class});
            xsd = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(ResourceUtils.getURL("classpath:META-INF/nucleus8583/schema/iso-message.xsd"));
        }
        catch (Exception e) {
            StringWriter w = new StringWriter();
            PrintWriter pw = new PrintWriter(w);
            e.printStackTrace(pw);
            pw.flush();
            throw new InternalError(w.toString());
        }
    }
}

