/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.BitSet;
import org.nucleus8583.core.Iso8583Field;
import org.nucleus8583.core.util.FastInteger;

public final class Iso8583String
extends Iso8583Field {
    private static final long serialVersionUID = -5615324004502124085L;

    public Iso8583String(int id, int lcount, int length, char align, char padWith, String emptyValue) {
        super(id, lcount, length, align, padWith, emptyValue);
    }

    public void pack(Writer writer, BitSet value) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void pack(Writer writer, BitSet value, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void pack(Writer writer, String value) throws IOException {
        int vlen = value.length();
        if (vlen > this.length) {
            throw new IllegalArgumentException("value of field #" + this.id + " is too long, expected " + this.length + " but actual is " + vlen);
        }
        if (this.lcount > 0) {
            FastInteger.writeUint(writer, vlen, this.lcount);
            writer.write(value, 0, vlen);
        } else {
            this.pad(writer, value, vlen);
        }
    }

    public void unpackBinary(Reader reader, BitSet bits) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void unpackBinary(Reader reader, BitSet bits, int off, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public BitSet unpackBinary(Reader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String unpackString(Reader reader) throws IOException {
        int unpackedLength = this.lcount > 0 ? FastInteger.readUint(reader, this.lcount) : this.length;
        char[] cbuf = new char[unpackedLength];
        this.read(reader, cbuf, unpackedLength);
        return this.lcount > 0 ? new String(cbuf) : new String(this.unpad(cbuf, unpackedLength));
    }
}

