/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core.charset.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class Utf8Decoder
extends Reader {
    private final InputStream in;

    public Utf8Decoder(InputStream in) {
        this.in = in;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int read() throws IOException {
        int ichar;
        boolean missing = false;
        int ubyte = this.in.read();
        if (ubyte < 0) {
            return -1;
        }
        if ((ubyte & 0x80) == 0) {
            ichar = ubyte;
        } else if ((ubyte & 0xE0) == 192) {
            ichar = ubyte & 0x1F;
            ubyte = this.in.read();
            if (ubyte < 0) {
                missing = true;
            } else {
                ichar = ichar << 6 | ubyte & 0x3F;
            }
        } else if ((ubyte & 0xF0) == 224) {
            ichar = ubyte & 0xF;
            ubyte = this.in.read();
            if (ubyte < 0) {
                missing = true;
            } else {
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                } else {
                    ichar = ichar << 6 | ubyte & 0x3F;
                }
            }
        } else if ((ubyte & 0xF8) == 240) {
            ichar = ubyte & 7;
            ubyte = this.in.read();
            if (ubyte < 0) {
                missing = true;
            } else {
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                } else {
                    ichar = ichar << 6 | ubyte & 0x3F;
                    ubyte = this.in.read();
                    if (ubyte < 0) {
                        missing = true;
                    } else {
                        ichar = ichar << 6 | ubyte & 0x3F;
                    }
                }
            }
        } else if ((ubyte & 0xFC) == 248) {
            ichar = ubyte & 3;
            ubyte = this.in.read();
            if (ubyte < 0) {
                missing = true;
            } else {
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                } else {
                    ichar = ichar << 6 | ubyte & 0x3F;
                    ubyte = this.in.read();
                    if (ubyte < 0) {
                        missing = true;
                    } else {
                        ichar = ichar << 6 | ubyte & 0x3F;
                        ubyte = this.in.read();
                        if (ubyte < 0) {
                            missing = true;
                        } else {
                            ichar = ichar << 6 | ubyte & 0x3F;
                        }
                    }
                }
            }
        } else if ((ubyte & 0xFE) == 252) {
            ichar = ubyte & 1;
            ubyte = this.in.read();
            if (ubyte < 0) {
                missing = true;
            } else {
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                } else {
                    ichar = ichar << 6 | ubyte & 0x3F;
                    ubyte = this.in.read();
                    if (ubyte < 0) {
                        missing = true;
                    } else {
                        ichar = ichar << 6 | ubyte & 0x3F;
                        ubyte = this.in.read();
                        if (ubyte < 0) {
                            missing = true;
                        } else {
                            ichar = ichar << 6 | ubyte & 0x3F;
                        }
                    }
                }
            }
        } else {
            throw new IOException("data stream contains value (code=" + ubyte + ") which is not compatible with UTF-8 encoding");
        }
        if (missing) {
            throw new IOException("missing data while reading in UTF-8 encoding");
        }
        return ichar;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int ubyte;
        int rlen;
        boolean missing = false;
        int j = off;
        for (rlen = 0; rlen < len && (ubyte = this.in.read()) >= 0; ++rlen) {
            int ichar;
            if ((ubyte & 0x80) == 0) {
                ichar = ubyte;
            } else if ((ubyte & 0xE0) == 192) {
                ichar = ubyte & 0x1F;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
            } else if ((ubyte & 0xF0) == 224) {
                ichar = ubyte & 0xF;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
            } else if ((ubyte & 0xF8) == 240) {
                ichar = ubyte & 7;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
            } else if ((ubyte & 0xFC) == 248) {
                ichar = ubyte & 3;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
            } else if ((ubyte & 0xFE) == 252) {
                ichar = ubyte & 1;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = this.in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
            } else {
                throw new IOException("data stream contains value (code=" + ubyte + ") which is not compatible with UTF-8 encoding");
            }
            cbuf[j++] = (char)ichar;
        }
        if (missing) {
            throw new IOException("missing data while reading in UTF-8 encoding");
        }
        return rlen;
    }
}

