/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core.charset.spi;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class Utf8Encoder
extends Writer {
    private final OutputStream out;

    public Utf8Encoder(OutputStream out) {
        this.out = out;
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(int ichar) throws IOException {
        if (ichar < 0) {
            throw new IOException("data contains value " + ((long)ichar & 0xFFFFFFFFL) + " which is not compatible with UTF-8 encoding");
        }
        if (ichar <= 127) {
            this.out.write(ichar);
        } else if (ichar <= 2047) {
            this.out.write(0xC0 | ichar >> 6);
            this.out.write(0x80 | ichar & 0x3F);
        } else if (ichar <= 65535) {
            this.out.write(0xE0 | ichar >> 12);
            this.out.write(0x80 | ichar >> 6 & 0x3F);
            this.out.write(0x80 | ichar & 0x3F);
        } else if (ichar <= 0x1FFFFF) {
            this.out.write(0xF0 | ichar >> 18);
            this.out.write(0x80 | ichar >> 12 & 0x3F);
            this.out.write(0x80 | ichar >> 6 & 0x3F);
            this.out.write(0x80 | ichar & 0x3F);
        } else if (ichar <= 0x3FFFFFF) {
            this.out.write(0xF8 | ichar >> 24);
            this.out.write(0x80 | ichar >> 18 & 0x3F);
            this.out.write(0x80 | ichar >> 12 & 0x3F);
            this.out.write(0x80 | ichar >> 6 & 0x3F);
            this.out.write(0x80 | ichar & 0x3F);
        } else {
            this.out.write(0xFC | ichar >> 30);
            this.out.write(0x80 | ichar >> 24 & 0x3F);
            this.out.write(0x80 | ichar >> 18 & 0x3F);
            this.out.write(0x80 | ichar >> 12 & 0x3F);
            this.out.write(0x80 | ichar >> 6 & 0x3F);
            this.out.write(0x80 | ichar & 0x3F);
        }
    }

    public void write(char[] cbuf) throws IOException {
        int len = cbuf.length;
        int i = 0;
        while (i < len) {
            this.write(cbuf[i++]);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (off == 0) {
            int i = 0;
            while (i < len) {
                this.write(cbuf[i++]);
            }
        } else {
            int j = off;
            for (int i = 0; i < len; ++i) {
                this.write(cbuf[j++]);
            }
        }
    }

    public void write(String str) throws IOException {
        int len = str.length();
        int i = 0;
        while (i < len) {
            this.write(str.charAt(i++) & 0x7F);
        }
    }

    public void write(String str, int off, int len) throws IOException {
        if (off == 0) {
            int i = 0;
            while (i < len) {
                this.write(str.charAt(i++));
            }
        } else {
            int j = off;
            for (int i = 0; i < len; ++i) {
                this.write(str.charAt(j++));
            }
        }
    }
}

