/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core.util;

import java.io.IOException;
import java.io.Reader;

public class FastStringReader
extends Reader {
    private String value;
    private int vlen;
    private int readIndex;
    private int remaining;

    public FastStringReader(String value) {
        this.value = value;
        this.vlen = value == null ? 0 : value.length();
        this.readIndex = 0;
        this.remaining = this.vlen;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.remaining == 0) {
            return -1;
        }
        int actualLen = Math.min(len, this.remaining);
        if (actualLen > 0) {
            this.value.getChars(this.readIndex, this.readIndex + actualLen, cbuf, off);
            this.readIndex += actualLen;
            this.remaining -= actualLen;
        }
        return actualLen;
    }

    public int read() throws IOException {
        if (this.remaining <= 0) {
            return -1;
        }
        char cc = this.value.charAt(this.readIndex);
        ++this.readIndex;
        --this.remaining;
        return cc;
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public long skip(long n) throws IOException {
        int actualN = Math.min(this.remaining, (int)n);
        this.readIndex += actualN;
        this.remaining -= actualN;
        return actualN;
    }

    public boolean ready() throws IOException {
        return this.remaining > 0;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readAheadLimit) throws IOException {
        throw new IOException();
    }

    public void reset() throws IOException {
        this.readIndex = 0;
        this.remaining = this.vlen;
    }

    public void close() throws IOException {
        this.readIndex = 0;
        this.remaining = 0;
        this.value = null;
        this.vlen = 0;
    }
}

