/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core.xml;

import java.lang.reflect.Constructor;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.nucleus8583.core.Iso8583Binary;
import org.nucleus8583.core.Iso8583Field;
import org.nucleus8583.core.Iso8583String;
import org.nucleus8583.core.util.FieldTypes;
import org.nucleus8583.core.xml.Iso8583FieldAlignments;

@XmlRootElement(name="iso-field", namespace="http://www.nucleus8583.org/schema/iso-message")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Iso8583FieldDefinition {
    public static final Iso8583FieldDefinition FIELD_0 = new Iso8583FieldDefinition();
    public static final Iso8583FieldDefinition FIELD_1;
    public static final Iso8583FieldDefinition FIELD_65;
    @XmlAttribute(name="id", required=true)
    private int id;
    @XmlAttribute(name="type", required=true)
    private String type;
    @XmlTransient
    private int lcount = 0;
    @XmlAttribute(name="length")
    private int length = 0;
    @XmlAttribute(name="align")
    private Iso8583FieldAlignments align = Iso8583FieldAlignments.NONE;
    @XmlAttribute(name="pad-with")
    private String padWith = " ";
    @XmlAttribute(name="empty-value")
    private String emptyValue = "";

    private void initLength() {
        this.type = this.type.trim();
        if (this.type.endsWith(".....")) {
            this.type = this.type.substring(0, this.type.length() - 5).trim();
            this.length = 99999;
            this.lcount = 5;
        } else if (this.type.endsWith("....")) {
            this.type = this.type.substring(0, this.type.length() - 4).trim();
            this.length = 9999;
            this.lcount = 4;
        } else if (this.type.endsWith("...")) {
            this.type = this.type.substring(0, this.type.length() - 3).trim();
            this.length = 999;
            this.lcount = 3;
        } else if (this.type.endsWith("..")) {
            this.type = this.type.substring(0, this.type.length() - 2).trim();
            this.length = 99;
            this.lcount = 2;
        } else if (this.type.endsWith(".")) {
            this.type = this.type.substring(0, this.type.length() - 1).trim();
            this.length = 9;
            this.lcount = 1;
        } else {
            if (this.length <= 0) {
                throw new IllegalArgumentException("length must greater than 0, given " + this.length + " in field with id = " + this.id);
            }
            this.lcount = 0;
        }
    }

    public int getId() {
        return this.id;
    }

    public Iso8583Field createField() {
        this.initLength();
        if ("a".equalsIgnoreCase(this.type)) {
            return new Iso8583String(this.id, this.lcount, this.length, Iso8583FieldAlignments.LEFT.symbolicValue(), ' ', "");
        }
        if ("n".equalsIgnoreCase(this.type)) {
            return new Iso8583String(this.id, this.lcount, this.length, Iso8583FieldAlignments.RIGHT.symbolicValue(), '0', "0");
        }
        if ("s".equalsIgnoreCase(this.type)) {
            return new Iso8583String(this.id, this.lcount, this.length, Iso8583FieldAlignments.LEFT.symbolicValue(), ' ', "");
        }
        if ("an".equalsIgnoreCase(this.type)) {
            return new Iso8583String(this.id, this.lcount, this.length, Iso8583FieldAlignments.LEFT.symbolicValue(), ' ', "");
        }
        if ("as".equalsIgnoreCase(this.type)) {
            return new Iso8583String(this.id, this.lcount, this.length, Iso8583FieldAlignments.LEFT.symbolicValue(), ' ', "");
        }
        if ("ns".equalsIgnoreCase(this.type)) {
            return new Iso8583String(this.id, this.lcount, this.length, Iso8583FieldAlignments.LEFT.symbolicValue(), ' ', "");
        }
        if ("ans".equalsIgnoreCase(this.type)) {
            return new Iso8583String(this.id, this.lcount, this.length, Iso8583FieldAlignments.LEFT.symbolicValue(), ' ', "");
        }
        if ("b".equalsIgnoreCase(this.type)) {
            return new Iso8583Binary(this.id, this.length);
        }
        if ("custom".equalsIgnoreCase(this.type)) {
            char cpadWith = ' ';
            if (this.padWith.length() > 0) {
                cpadWith = this.padWith.charAt(0);
            }
            return new Iso8583String(this.id, this.lcount, this.length, this.align.symbolicValue(), cpadWith, this.emptyValue);
        }
        Constructor<?> ctor = FieldTypes.getConstructor(this.type);
        if (ctor != null) {
            char cpadWith = ' ';
            if (this.padWith.length() > 0) {
                cpadWith = this.padWith.charAt(0);
            }
            try {
                return (Iso8583Field)ctor.newInstance(this.id, this.lcount, this.length, Character.valueOf(this.align.symbolicValue()), Character.valueOf(cpadWith), this.emptyValue);
            }
            catch (Throwable t) {
                throw new RuntimeException("unable to instantiate field type " + this.type, t);
            }
        }
        throw new RuntimeException("unknown type " + this.type);
    }

    static {
        Iso8583FieldDefinition.FIELD_0.id = 0;
        Iso8583FieldDefinition.FIELD_0.type = "an";
        Iso8583FieldDefinition.FIELD_0.lcount = 0;
        Iso8583FieldDefinition.FIELD_0.length = 4;
        Iso8583FieldDefinition.FIELD_0.align = Iso8583FieldAlignments.NONE;
        Iso8583FieldDefinition.FIELD_0.padWith = " ";
        Iso8583FieldDefinition.FIELD_0.emptyValue = "";
        FIELD_1 = new Iso8583FieldDefinition();
        Iso8583FieldDefinition.FIELD_1.id = 1;
        Iso8583FieldDefinition.FIELD_1.type = "b";
        Iso8583FieldDefinition.FIELD_1.lcount = 0;
        Iso8583FieldDefinition.FIELD_1.length = 16;
        Iso8583FieldDefinition.FIELD_1.align = Iso8583FieldAlignments.NONE;
        Iso8583FieldDefinition.FIELD_1.padWith = null;
        Iso8583FieldDefinition.FIELD_1.emptyValue = null;
        FIELD_65 = new Iso8583FieldDefinition();
        Iso8583FieldDefinition.FIELD_65.id = 65;
        Iso8583FieldDefinition.FIELD_65.type = "b";
        Iso8583FieldDefinition.FIELD_65.lcount = 0;
        Iso8583FieldDefinition.FIELD_65.length = 8;
        Iso8583FieldDefinition.FIELD_65.align = Iso8583FieldAlignments.NONE;
        Iso8583FieldDefinition.FIELD_65.padWith = null;
        Iso8583FieldDefinition.FIELD_65.emptyValue = null;
    }
}

