/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core.xml;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.nucleus8583.core.Iso8583Binary;
import org.nucleus8583.core.Iso8583Field;
import org.nucleus8583.core.Iso8583Message;
import org.nucleus8583.core.charset.Charsets;
import org.nucleus8583.core.charset.spi.CharsetProvider;
import org.nucleus8583.core.xml.Iso8583FieldDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="iso-message", namespace="http://www.nucleus8583.org/schema/iso-message")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Iso8583MessageDefinition {
    @XmlTransient
    private static Comparator<Iso8583Field> byFieldId = new Comparator<Iso8583Field>(){

        @Override
        public int compare(Iso8583Field a, Iso8583Field b) {
            return a.getId() - b.getId();
        }
    };
    @XmlAttribute(name="encoding", required=true)
    private String encoding;
    @XmlElementRef
    private List<Iso8583FieldDefinition> fields;
    @XmlTransient
    private boolean hasMti;
    @XmlTransient
    private Iso8583Field[] tpl_fields;
    @XmlTransient
    private int tpl_fields_count;
    @XmlTransient
    private boolean[] tpl_binaries;
    @XmlTransient
    private CharsetProvider tpl_provider;

    public String getEncoding() {
        return this.encoding;
    }

    public CharsetProvider getCharsetProvider() {
        return this.tpl_provider;
    }

    public boolean hasMti() {
        return this.hasMti;
    }

    public Iso8583Field[] getFields() {
        return this.tpl_fields;
    }

    public boolean[] getBinaries() {
        return this.tpl_binaries;
    }

    private boolean replace(int id, Iso8583FieldDefinition newdef, List<Iso8583FieldDefinition> fields, int count) {
        for (int i = 0; i < count; ++i) {
            Iso8583FieldDefinition def = fields.get(i);
            if (def.getId() != id) continue;
            fields.set(i, newdef);
            return true;
        }
        return false;
    }

    private void checkDuplicateId(List<Iso8583FieldDefinition> list, int count) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < count; ++i) {
            Integer id = list.get(i).getId();
            if (set.contains(id)) {
                throw new IllegalArgumentException("duplicate id " + id + " found");
            }
            set.add(id);
        }
    }

    public void createMessageTemplate() {
        int i;
        List<Iso8583FieldDefinition> fields = this.fields;
        int count = fields.size();
        this.hasMti = this.replace(0, Iso8583FieldDefinition.FIELD_0, fields, count);
        if (!this.hasMti) {
            fields.add(Iso8583FieldDefinition.FIELD_0);
        }
        if (!this.replace(1, Iso8583FieldDefinition.FIELD_1, fields, count)) {
            fields.add(Iso8583FieldDefinition.FIELD_1);
        }
        if (!this.replace(65, Iso8583FieldDefinition.FIELD_65, fields, count)) {
            fields.add(Iso8583FieldDefinition.FIELD_65);
        }
        this.checkDuplicateId(fields, count);
        this.tpl_fields_count = fields.size();
        this.tpl_fields = new Iso8583Field[this.tpl_fields_count];
        for (i = 0; i < this.tpl_fields_count; ++i) {
            this.tpl_fields[i] = fields.get(i).createField();
        }
        Arrays.sort(this.tpl_fields, byFieldId);
        for (i = 2; i < this.tpl_fields_count; ++i) {
            if (this.tpl_fields[i].getId() == i) continue;
            throw new IllegalArgumentException("field #" + i + " is not defined");
        }
        this.tpl_binaries = new boolean[this.tpl_fields_count];
        for (i = this.tpl_fields_count - 1; i >= 0; --i) {
            this.tpl_binaries[i] = this.tpl_fields[i] instanceof Iso8583Binary;
        }
        this.tpl_provider = Charsets.getProvider(this.encoding);
        if (this.tpl_provider == null) {
            throw new RuntimeException(new UnsupportedEncodingException(this.encoding));
        }
    }

    public Iso8583Message createMessage() {
        return new Iso8583Message(this.hasMti, this.tpl_fields, this.tpl_binaries, this.tpl_provider, this.tpl_fields_count);
    }
}

