/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import org.nucleus8583.core.Iso8583Message;
import org.nucleus8583.core.charset.CharsetDecoder;
import org.nucleus8583.core.charset.CharsetEncoder;
import org.nucleus8583.core.charset.CharsetProvider;
import org.nucleus8583.core.charset.Charsets;
import org.nucleus8583.core.field.type.FieldType;
import org.nucleus8583.core.field.type.FieldTypes;
import org.nucleus8583.core.util.BitmapHelper;
import org.nucleus8583.core.util.ResourceUtils;
import org.nucleus8583.core.xml.Iso8583FieldDefinition;
import org.nucleus8583.core.xml.Iso8583MessageDefinition;
import org.w3c.dom.Node;

public final class Iso8583MessageSerializer {
    private static final JAXBContext ctx;
    private static final Comparator<FieldType> sortByFieldId;
    private FieldType[] fields;
    private boolean[] binaries;
    private int fieldsCount;
    private String encoding;
    private CharsetEncoder charsetEncoder;
    private CharsetDecoder charsetDecoder;

    public static Iso8583MessageSerializer create(String location) {
        return new Iso8583MessageSerializer(location);
    }

    public static Iso8583MessageSerializer create(InputStream in) {
        return new Iso8583MessageSerializer(in);
    }

    public static Iso8583MessageSerializer create(Node node) {
        return new Iso8583MessageSerializer(node);
    }

    public Iso8583MessageSerializer(String location) {
        Iso8583MessageDefinition definition;
        URL found = ResourceUtils.getURL(location);
        if (found == null) {
            throw new RuntimeException("unable to find " + location);
        }
        try {
            definition = (Iso8583MessageDefinition)ctx.createUnmarshaller().unmarshal(found);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.init(definition);
    }

    public Iso8583MessageSerializer(InputStream in) {
        Iso8583MessageDefinition definition;
        try {
            definition = (Iso8583MessageDefinition)ctx.createUnmarshaller().unmarshal(in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.init(definition);
    }

    public Iso8583MessageSerializer(Node node) {
        Iso8583MessageDefinition definition;
        try {
            definition = (Iso8583MessageDefinition)ctx.createUnmarshaller().unmarshal(node);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.init(definition);
    }

    private void init(Iso8583MessageDefinition definition) {
        int i;
        List<Iso8583FieldDefinition> fields = definition.getFields();
        this.fieldsCount = fields.size();
        this.fields = new FieldType[this.fieldsCount];
        for (i = 0; i < this.fieldsCount; ++i) {
            this.fields[i] = FieldTypes.getType(fields.get(i));
        }
        Arrays.sort(this.fields, sortByFieldId);
        for (i = 0; i < this.fieldsCount; ++i) {
            if (this.fields[i].getId() == i) continue;
            throw new IllegalArgumentException("field #" + i + " is not defined");
        }
        this.binaries = new boolean[this.fieldsCount];
        for (i = this.fieldsCount - 1; i >= 0; --i) {
            this.binaries[i] = this.fields[i].isBinary();
        }
        this.encoding = definition.getEncoding();
        CharsetProvider charsetProvider = Charsets.getProvider(this.encoding);
        if (charsetProvider == null) {
            throw new RuntimeException(new UnsupportedEncodingException(this.encoding));
        }
        this.charsetEncoder = charsetProvider.getEncoder();
        this.charsetDecoder = charsetProvider.getDecoder();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void read(byte[] buf, Iso8583Message out) throws IOException {
        this.read(new ByteArrayInputStream(buf), out);
    }

    public void read(InputStream in, Iso8583Message out) throws IOException {
        byte[] bits1To128 = out.directBits1To128();
        byte[] bits129To192 = out.directBits129To192();
        int count = out.size();
        if (count > this.fieldsCount) {
            count = this.fieldsCount;
        }
        out.setMti(this.fields[0].readString(in, this.charsetDecoder));
        this.fields[1].read(in, this.charsetDecoder, bits1To128);
        int i = 2;
        int iMin1 = 1;
        int iMin129 = -127;
        while (i < count) {
            if (i == 65) {
                if (BitmapHelper.get(bits1To128, 64)) {
                    this.fields[i].read(in, this.charsetDecoder, bits129To192);
                }
            } else if (i < 129) {
                if (BitmapHelper.get(bits1To128, iMin1)) {
                    if (this.binaries[i]) {
                        out.unsafeSet(i, this.fields[i].readBinary(in, this.charsetDecoder));
                    } else {
                        out.unsafeSet(i, this.fields[i].readString(in, this.charsetDecoder));
                    }
                }
            } else if (BitmapHelper.get(bits129To192, iMin129)) {
                if (this.binaries[i]) {
                    out.unsafeSet(i, this.fields[i].readBinary(in, this.charsetDecoder));
                } else {
                    out.unsafeSet(i, this.fields[i].readString(in, this.charsetDecoder));
                }
            }
            ++i;
            ++iMin1;
            ++iMin129;
        }
    }

    public void write(Iso8583Message msg, OutputStream out) throws IOException {
        byte[] bits1To128 = msg.directBits1To128();
        byte[] bits129To192 = msg.directBits129To192();
        String mti = msg.getMti();
        byte[][] binaryValues = msg.directBinaryValues();
        String[] stringValues = msg.directStringValues();
        if (BitmapHelper.isEmpty(bits129To192)) {
            BitmapHelper.clear(bits1To128, 64);
            binaryValues[65] = null;
            stringValues[65] = null;
        } else {
            BitmapHelper.set(bits1To128, 64);
            binaryValues[65] = bits129To192;
            stringValues[65] = null;
        }
        BitmapHelper.clear(bits1To128, 0);
        int count = msg.size();
        if (count > this.fieldsCount) {
            count = this.fieldsCount;
        }
        this.fields[0].write(out, this.charsetEncoder, mti);
        this.fields[1].write(out, this.charsetEncoder, bits1To128);
        int i = 2;
        int j = 1;
        while (i < count && i < 129) {
            if (BitmapHelper.get(bits1To128, j)) {
                if (this.binaries[i]) {
                    this.fields[i].write(out, this.charsetEncoder, binaryValues[i]);
                } else {
                    this.fields[i].write(out, this.charsetEncoder, stringValues[i]);
                }
            }
            ++i;
            ++j;
        }
        i = 129;
        j = 0;
        while (i < count) {
            if (BitmapHelper.get(bits129To192, j)) {
                if (this.binaries[i]) {
                    this.fields[i].write(out, this.charsetEncoder, binaryValues[i]);
                } else {
                    this.fields[i].write(out, this.charsetEncoder, stringValues[i]);
                }
            }
            ++i;
            ++j;
        }
    }

    static {
        sortByFieldId = new Comparator<FieldType>(){

            @Override
            public int compare(FieldType a, FieldType b) {
                return a.getId() - b.getId();
            }
        };
        try {
            ctx = JAXBContext.newInstance((Class[])new Class[]{Iso8583MessageDefinition.class});
        }
        catch (Exception e) {
            StringWriter w = new StringWriter();
            PrintWriter pw = new PrintWriter(w);
            e.printStackTrace(pw);
            pw.flush();
            throw new InternalError(w.toString());
        }
    }
}

